/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.AttributeHandler;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class Attribute {
    private Attribute next;
    private int nameIndex;
    private int length;
    private byte[] info;

    public Attribute(int nameIndex, int length, byte[] info) {
        this.nameIndex = nameIndex;
        this.length = length;
        this.info = info;
    }

    public Attribute getNext() {
        return this.next;
    }

    public void setNext(Attribute next) {
        this.next = next;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public void setInfo(byte[] info) {
        this.info = info;
    }

    public static Attribute readTable(DataInputStream dataIn, ConstantPool cpool, AttributeHandler handler) throws IOException, ClassFileFormatException {
        Attribute head = null;
        int count = dataIn.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            int nameIndex = dataIn.readUnsignedShort();
            String name = cpool.getUtf8AsString(nameIndex);
            int length = dataIn.readInt();
            Attribute attribute = null;
            boolean done = false;
            if (handler != null) {
                done = handler.handleAttribute(dataIn, name, length);
            }
            if (!done) {
                byte[] info = new byte[length];
                dataIn.readFully(info);
                attribute = new Attribute(nameIndex, length, info);
            }
            if (attribute == null) continue;
            attribute.setNext(head);
            head = attribute;
        }
        return head;
    }

    public static void writeTable(DataOutput dataOut, Attribute head) throws IOException {
        for (Attribute a = head; a != null; a = a.getNext()) {
            dataOut.writeShort(a.getNameIndex());
            dataOut.writeInt(a.getLength());
            byte[] info = a.getInfo();
            if (info == null || info.length <= 0) continue;
            dataOut.write(info);
        }
    }

    public static void writeAttribute(DataOutput dataOut, ConstantPool cp, String name, int length, int data) throws IOException {
        int nameIndex = cp.addUtf8(name).getIndex();
        dataOut.writeShort(nameIndex);
        dataOut.writeInt(length);
        if (length > 0) {
            dataOut.writeShort(data);
        }
    }

    public static void writeAttribute(DataOutput dout, ConstantPool cp, String name, int length) throws IOException {
        int nameIndex = cp.addUtf8(name).getIndex();
        dout.writeShort(nameIndex);
        dout.writeInt(length);
    }

    public static int getTotalSize(Attribute attributes) {
        int size = 0;
        for (Attribute a = attributes; a != null; a = a.getNext()) {
            size += 6 + a.getLength();
        }
        return size;
    }
}

