/*
 * Decompiled with CFR 0.152.
 */
package org.benjchristensen.doclet;

import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.standard.Standard;
import com.sun.tools.javadoc.Main;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class DocletExclude {
    public static void main(String[] args) {
        String name = DocletExclude.class.getName();
        Main.execute((String)name, (String)name, (String[])args);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) throws IOException {
        return Standard.validOptions((String[][])options, (DocErrorReporter)reporter);
    }

    private static boolean exclude(Doc doc) {
        if (doc.name().contains("UnitTest")) {
            return true;
        }
        if (doc.tags("@ExcludeFromJavadoc").length > 0) {
            return true;
        }
        return doc instanceof ProgramElementDoc && ((ProgramElementDoc)doc).containingPackage().tags("@ExcludeFromJavadoc").length > 0;
    }

    public static int optionLength(String option) {
        return Standard.optionLength((String)option);
    }

    public static boolean start(RootDoc root) throws IOException {
        return Standard.start((RootDoc)((RootDoc)DocletExclude.process(root, RootDoc.class)));
    }

    private static Object process(Object obj, Class expect) {
        if (obj == null) {
            return null;
        }
        Class<?> cls = obj.getClass();
        if (cls.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), (InvocationHandler)new ExcludeHandler(obj));
        }
        if (obj instanceof Object[]) {
            Class<?> componentType = expect.getComponentType();
            Object[] array = (Object[])obj;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            int i = 0;
            while (i < array.length) {
                Object entry = array[i];
                if (!(entry instanceof Doc) || !DocletExclude.exclude((Doc)entry)) {
                    list.add(DocletExclude.process(entry, componentType));
                }
                ++i;
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return obj;
    }

    private static class ExcludeHandler
    implements InvocationHandler {
        private Object target;

        public ExcludeHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            if (args != null && ((methodName = method.getName()).equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = this.unwrap(args[0]);
            }
            try {
                return DocletExclude.process(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((ExcludeHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }
    }
}

