/*
 * Copyright (c) 2011-2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package io.vertx.ext.web.proxy.handler;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.proxy.handler.impl.ProxyHandlerImpl;
import io.vertx.httpproxy.HttpProxy;

/**
 * @author <a href="mailto:emad.albloushi@gmail.com">Emad Alblueshi</a>
 */

@VertxGen
public interface ProxyHandler extends Handler<RoutingContext> {

  static ProxyHandler create(HttpProxy httpProxy) {
    return new ProxyHandlerImpl(httpProxy);
  }

  static ProxyHandler create(HttpProxy httpProxy, int port, String host) {
    return new ProxyHandlerImpl(httpProxy, port, host);
  }
}
