/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.IntEnumeration;
import com.mchange.util.IntObjectMap;
import com.mchange.util.impl.IOHRecElem;
import com.mchange.util.impl.IOHRecord;
import com.mchange.util.impl.IntEnumerationHelperBase;
import java.util.NoSuchElementException;

public class IntObjectHash
implements IntObjectMap {
    IOHRecord[] records;
    int init_capacity;
    float load_factor;
    int threshold;
    int size;

    public IntObjectHash(int init_capacity, float load_factor) {
        this.init_capacity = init_capacity;
        this.load_factor = load_factor;
        this.clear();
    }

    public IntObjectHash() {
        this(101, 0.75f);
    }

    public synchronized Object get(int num) {
        int index = this.getIndex(num);
        Object out = null;
        if (this.records[index] != null) {
            out = this.records[index].get(num);
        }
        return out;
    }

    public synchronized void put(int num, Object obj) {
        boolean replaced;
        if (obj == null) {
            throw new NullPointerException("Null values not permitted.");
        }
        int index = this.getIndex(num);
        if (this.records[index] == null) {
            this.records[index] = new IOHRecord(index);
        }
        if (!(replaced = this.records[index].add(num, obj, true))) {
            ++this.size;
        }
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    public synchronized boolean putNoReplace(int num, Object obj) {
        boolean needed_replace;
        if (obj == null) {
            throw new NullPointerException("Null values not permitted.");
        }
        int index = this.getIndex(num);
        if (this.records[index] == null) {
            this.records[index] = new IOHRecord(index);
        }
        if (needed_replace = this.records[index].add(num, obj, false)) {
            return false;
        }
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized boolean containsInt(int num) {
        int index = this.getIndex(num);
        return this.records[index] != null && this.records[index].findInt(num) != null;
    }

    private int getIndex(int num) {
        return Math.abs(num % this.records.length);
    }

    public synchronized Object remove(int num) {
        Object out;
        IOHRecord rec = this.records[this.getIndex(num)];
        Object object = out = rec == null ? null : rec.remove(num);
        if (out != null) {
            --this.size;
        }
        return out;
    }

    public synchronized void clear() {
        this.records = new IOHRecord[this.init_capacity];
        this.threshold = (int)(this.load_factor * (float)this.init_capacity);
        this.size = 0;
    }

    public synchronized IntEnumeration ints() {
        return new IntEnumerationHelperBase(){
            int index = -1;
            IOHRecElem finger;
            {
                this.nextIndex();
            }

            public boolean hasMoreInts() {
                return this.index < IntObjectHash.this.records.length;
            }

            public int nextInt() {
                try {
                    int out = this.finger.num;
                    this.findNext();
                    return out;
                }
                catch (NullPointerException e) {
                    throw new NoSuchElementException();
                }
            }

            private void findNext() {
                if (this.finger.next != null) {
                    this.finger = this.finger.next;
                } else {
                    this.nextIndex();
                }
            }

            private void nextIndex() {
                try {
                    int len = IntObjectHash.this.records.length;
                    do {
                        ++this.index;
                    } while (IntObjectHash.this.records[this.index] == null && this.index <= len);
                    this.finger = IntObjectHash.this.records[this.index].next;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.finger = null;
                }
            }
        };
    }

    protected void rehash() {
        IOHRecord[] newRecords = new IOHRecord[this.records.length * 2];
        for (int i = 0; i < this.records.length; ++i) {
            if (this.records[i] == null) continue;
            newRecords[i] = this.records[i];
            newRecords[i * 2] = this.records[i].split(newRecords.length);
        }
        this.records = newRecords;
        this.threshold = (int)(this.load_factor * (float)this.records.length);
    }
}

