/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.bpmn.client.documentation.decorator;

import java.util.Optional;
import java.util.function.Supplier;

import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.DefaultRoute;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class DefaultRouteDecorator implements PropertyDecorator {

    private final DefaultRoute defaultRoute;
    private final Supplier<CanvasHandler> canvasHandlerSupplier;
    private final DefinitionUtils definitionUtils;

    public DefaultRouteDecorator(final DefaultRoute defaultRoute, final Supplier<CanvasHandler> canvasHandlerSupplier,
                                 final DefinitionUtils definitionUtils) {
        this.defaultRoute = defaultRoute;
        this.canvasHandlerSupplier = canvasHandlerSupplier;
        this.definitionUtils = definitionUtils;
    }

    @Override
    public String getValue() {
        final String propertyValue = defaultRoute.getValue();
        return Optional.ofNullable(canvasHandlerSupplier.get())
                .filter(c -> c instanceof AbstractCanvasHandler)
                .map(c -> (AbstractCanvasHandler) c).map(AbstractCanvasHandler::getGraphIndex)
                .map(index -> index.getEdge(propertyValue))
                .map(Edge::getTargetNode)
                .map(node -> ((Node) node).getContent())
                .filter(c -> c instanceof Definition)
                .map(c -> (Definition) c)
                .map(Definition::getDefinition)
                .map(def -> definitionUtils.getName(def))
                .orElse(propertyValue);
    }
}
