/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.forms.dynamic.client.rendering.renderers.date.input;

import java.util.Date;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class DatePickerWrapperTest {

    @Mock
    private DatePickerWrapperView view;

    private DatePickerWrapper presenter;

    @Before
    public void init() {
        presenter = new DatePickerWrapper(view);
    }

    @Test
    public void testDatePickerValue() {

        verify(view).setPresenter(presenter);

        presenter.asWidget();

        presenter.setDatePickerWidget(true);

        Date today = new Date();

        presenter.setValue(today, true);
    }
}
