/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;

import static org.junit.Assert.assertEquals;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_DataTypes;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_DiagramDoesNotHaveElements;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_DmnModel;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_DmnModelDocumentation;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_DrdComponents;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_GeneratedBy;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_GeneratedFrom;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_GeneratedOn;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_Namespace;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_NoDRDs;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_NoDataTypes;
import static org.kie.workbench.common.dmn.client.resources.i18n.DMNEditorConstants.DMNDocumentationI18n_TableOfContents;
import static org.mockito.Mockito.when;

@RunWith(GwtMockitoTestRunner.class)
public class DMNDocumentationI18nTest {

    @Mock
    private TranslationService translationService;

    @Test
    public void testCreate() {

        when(translationService.format(DMNDocumentationI18n_DmnModelDocumentation)).thenReturn("DMN model documentation");
        when(translationService.format(DMNDocumentationI18n_GeneratedOn)).thenReturn("Generated on:");
        when(translationService.format(DMNDocumentationI18n_GeneratedBy)).thenReturn("Generated by:");
        when(translationService.format(DMNDocumentationI18n_GeneratedFrom)).thenReturn("Generated from:");
        when(translationService.format(DMNDocumentationI18n_Namespace)).thenReturn("Namespace:");
        when(translationService.format(DMNDocumentationI18n_TableOfContents)).thenReturn("Table of contents");
        when(translationService.format(DMNDocumentationI18n_DmnModel)).thenReturn("DMN model");
        when(translationService.format(DMNDocumentationI18n_DataTypes)).thenReturn("Data Types");
        when(translationService.format(DMNDocumentationI18n_DrdComponents)).thenReturn("DRD components");
        when(translationService.format(DMNDocumentationI18n_NoDataTypes)).thenReturn("No data types.");
        when(translationService.format(DMNDocumentationI18n_NoDRDs)).thenReturn("No DRDs components.");
        when(translationService.format(DMNDocumentationI18n_DiagramDoesNotHaveElements)).thenReturn("Diagram does not have any element.");

        final DMNDocumentationI18n i18n = DMNDocumentationI18n.create(translationService);

        assertEquals("DMN model documentation", i18n.getDmnModelDocumentation());
        assertEquals("Generated on:", i18n.getGeneratedOn());
        assertEquals("Generated by:", i18n.getGeneratedBy());
        assertEquals("Generated from:", i18n.getGeneratedFrom());
        assertEquals("Namespace:", i18n.getNamespace());
        assertEquals("Table of contents", i18n.getTableOfContents());
        assertEquals("DMN model", i18n.getDmnModel());
        assertEquals("Data Types", i18n.getDataTypes());
        assertEquals("DRD components", i18n.getDrdComponents());
        assertEquals("No data types.", i18n.getNoDataTypes());
        assertEquals("No DRDs components.", i18n.getNoDRDs());
        assertEquals("Diagram does not have any element.", i18n.getDiagramDoesNotHaveElements());
    }
}
