/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.wb.test.rest.security;

import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.WorkbenchClient;

import static org.assertj.core.api.Assertions.assertThat;
import static org.kie.wb.test.rest.client.RestWorkbenchClient.createAsyncWorkbenchClient;

public class HealthCheckServiceIntegrationTest extends RestTestBase {

    private static final String SUCCESS = "success";

    private static WorkbenchClient asyncClient;

    @BeforeClass
    public static void setUp() {
        asyncClient = createAsyncWorkbenchClient(URL, null, null);
    }

    @Test
    public void testGetReady() {
        assertThat(asyncClient.isReady()).contains(SUCCESS).contains(String.valueOf(true));
    }

    @Test
    public void testGetHealthy() {
        assertThat(asyncClient.isHealthy()).contains("success").contains(String.valueOf(true));
    }
}