/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jstl.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jstl.core.IndexedValueExpression;
import com.sun.faces.facelets.tag.jstl.core.IteratedValueExpression;
import com.sun.faces.facelets.tag.jstl.core.IterationStatusExpression;
import com.sun.faces.facelets.tag.jstl.core.JstlIterationStatus;
import com.sun.faces.facelets.tag.jstl.core.MappedValueExpression;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;

public final class ForEachHandler
extends TagHandlerImpl {
    private final TagAttribute begin;
    private final TagAttribute end;
    private final TagAttribute items = this.getAttribute("items");
    private final TagAttribute step;
    private final TagAttribute tranzient;
    private final TagAttribute var = this.getAttribute("var");
    private final TagAttribute varStatus;

    public ForEachHandler(TagConfig config) {
        super(config);
        this.begin = this.getAttribute("begin");
        this.end = this.getAttribute("end");
        this.step = this.getAttribute("step");
        this.varStatus = this.getAttribute("varStatus");
        this.tranzient = this.getAttribute("transient");
        if (this.items == null && this.begin != null && this.end == null) {
            throw new TagAttributeException(this.tag, this.begin, "If the 'items' attribute is not specified, but the 'begin' attribute is, then the 'end' attribute is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        Iterator itr;
        int i;
        Object src;
        String prefix = ctx.generateUniqueId(this.tagId);
        int s = this.getBegin(ctx);
        int e = this.getEnd(ctx);
        int m = this.getStep(ctx);
        Integer sO = this.begin != null ? Integer.valueOf(s) : null;
        Integer eO = this.end != null ? Integer.valueOf(e) : null;
        Integer mO = this.step != null ? Integer.valueOf(m) : null;
        boolean t = this.getTransient(ctx);
        ValueExpression srcVE = null;
        if (this.items != null) {
            srcVE = this.items.getValueExpression(ctx, Object.class);
            src = srcVE.getValue((ELContext)ctx);
        } else {
            byte[] b = new byte[e + 1];
            for (i = 0; i < b.length; ++i) {
                b[i] = (byte)i;
            }
            src = b;
        }
        if (src != null && (itr = this.toIterator(src)) != null) {
            for (i = 0; i < s && itr.hasNext(); ++i) {
                itr.next();
            }
            String v = this.getVarName(ctx);
            String vs = this.getVarStatusName(ctx);
            VariableMapper vars = ctx.getVariableMapper();
            ValueExpression vO = this.capture(v, vars);
            ValueExpression vsO = this.capture(vs, vars);
            int count = 0;
            try {
                boolean first = true;
                while (i <= e && itr.hasNext()) {
                    ValueExpression ve;
                    ++count;
                    Object value = itr.next();
                    if (v != null) {
                        if (t || srcVE == null) {
                            ctx.setAttribute(v, value);
                        } else {
                            ve = this.getVarExpr(srcVE, src, value, i);
                            vars.setVariable(v, ve);
                        }
                    }
                    if (vs != null) {
                        JstlIterationStatus itrS = new JstlIterationStatus(first, !itr.hasNext(), i, sO, eO, mO, value, count);
                        if (t || srcVE == null) {
                            ctx.setAttribute(vs, (Object)itrS);
                        } else {
                            ve = new IterationStatusExpression(itrS);
                            vars.setVariable(vs, ve);
                        }
                    }
                    ForEachFaceletContext faceletContext = new ForEachFaceletContext(ctx, prefix, i);
                    this.nextHandler.apply((FaceletContext)faceletContext, parent);
                    int mi = 1;
                    while (mi < m && itr.hasNext()) {
                        itr.next();
                        ++mi;
                        ++i;
                    }
                    ++i;
                    first = false;
                }
            }
            finally {
                if (v != null) {
                    vars.setVariable(v, vO);
                }
                if (vs != null) {
                    vars.setVariable(vs, vsO);
                }
            }
        }
    }

    private ValueExpression capture(String name, VariableMapper vars) {
        if (name != null) {
            return vars.setVariable(name, null);
        }
        return null;
    }

    private int getBegin(FaceletContext ctx) {
        if (this.begin != null) {
            return this.begin.getInt(ctx);
        }
        return 0;
    }

    private int getEnd(FaceletContext ctx) {
        if (this.end != null) {
            return this.end.getInt(ctx);
        }
        return 0x7FFFFFFE;
    }

    private int getStep(FaceletContext ctx) {
        if (this.step != null) {
            return this.step.getInt(ctx);
        }
        return 1;
    }

    private boolean getTransient(FaceletContext ctx) {
        if (this.tranzient != null) {
            return this.tranzient.getBoolean(ctx);
        }
        return false;
    }

    private ValueExpression getVarExpr(ValueExpression ve, Object src, Object value, int i) {
        if (src instanceof List || src.getClass().isArray()) {
            return new IndexedValueExpression(ve, i);
        }
        if (src instanceof Map && value instanceof Map.Entry) {
            return new MappedValueExpression(ve, (Map.Entry)value);
        }
        if (src instanceof Collection) {
            return new IteratedValueExpression(ve, value);
        }
        throw new IllegalStateException("Cannot create VE for: " + src);
    }

    private String getVarName(FaceletContext ctx) {
        if (this.var != null) {
            return this.var.getValue(ctx);
        }
        return null;
    }

    private String getVarStatusName(FaceletContext ctx) {
        if (this.varStatus != null) {
            return this.varStatus.getValue(ctx);
        }
        return null;
    }

    private Iterator toIterator(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof Collection) {
            return ((Collection)src).iterator();
        }
        if (src instanceof Map) {
            return ((Map)src).entrySet().iterator();
        }
        if (src.getClass().isArray()) {
            return new ArrayIterator(src);
        }
        throw new TagAttributeException(this.tag, this.items, "Must evaluate to a Collection, Map, Array, or null.");
    }

    private static class ForEachFaceletContext
    extends FaceletContext {
        private String prefix;
        private int index;
        private FaceletContext faceletContext;
        private final Map<String, Integer> ids;

        private ForEachFaceletContext(FaceletContext faceletContext, String prefix, int index) {
            this.faceletContext = faceletContext;
            this.prefix = prefix;
            this.index = index;
            this.ids = new HashMap<String, Integer>();
        }

        public FacesContext getFacesContext() {
            return this.faceletContext.getFacesContext();
        }

        public String generateUniqueId(String base) {
            StringBuilder uniqueIdBuilder = new StringBuilder();
            Integer cnt = this.ids.get(base);
            if (cnt == null) {
                this.ids.put(base, 0);
                uniqueIdBuilder.delete(0, uniqueIdBuilder.length());
                uniqueIdBuilder.append(this.prefix);
                uniqueIdBuilder.append("_");
                uniqueIdBuilder.append(this.index);
                uniqueIdBuilder.append("_");
                uniqueIdBuilder.append(base);
            } else {
                int i = cnt + 1;
                this.ids.put(base, i);
                uniqueIdBuilder.delete(0, uniqueIdBuilder.length());
                uniqueIdBuilder.append(this.prefix);
                uniqueIdBuilder.append("_");
                uniqueIdBuilder.append(this.index);
                uniqueIdBuilder.append("_");
                uniqueIdBuilder.append(base);
                uniqueIdBuilder.append("_");
                uniqueIdBuilder.append(i);
            }
            return uniqueIdBuilder.toString();
        }

        public ExpressionFactory getExpressionFactory() {
            return this.faceletContext.getExpressionFactory();
        }

        public void setVariableMapper(VariableMapper varMapper) {
            this.faceletContext.setVariableMapper(varMapper);
        }

        public void setFunctionMapper(FunctionMapper fnMapper) {
            this.faceletContext.setFunctionMapper(fnMapper);
        }

        public void setAttribute(String name, Object value) {
            this.faceletContext.setAttribute(name, value);
        }

        public Object getAttribute(String name) {
            return this.faceletContext.getAttribute(name);
        }

        public void includeFacelet(UIComponent parent, String relativePath) throws IOException {
            this.faceletContext.includeFacelet(parent, relativePath);
        }

        public void includeFacelet(UIComponent parent, URL absolutePath) throws IOException {
            this.faceletContext.includeFacelet(parent, absolutePath);
        }

        public ELResolver getELResolver() {
            return this.faceletContext.getELResolver();
        }

        public FunctionMapper getFunctionMapper() {
            return this.faceletContext.getFunctionMapper();
        }

        public VariableMapper getVariableMapper() {
            return this.faceletContext.getVariableMapper();
        }

        public Object getContext(Class key) {
            return this.faceletContext.getContext(key);
        }

        public Locale getLocale() {
            return this.faceletContext.getLocale();
        }

        public int getIndex() {
            return this.index;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isPropertyResolved() {
            return this.faceletContext.isPropertyResolved();
        }

        public void putContext(Class key, Object contextObject) {
            this.faceletContext.putContext(key, contextObject);
        }

        public void setLocale(Locale locale) {
            this.faceletContext.setLocale(locale);
        }

        public void setPropertyResolved(boolean resolved) {
            this.faceletContext.setPropertyResolved(resolved);
        }
    }

    private static class ArrayIterator
    implements Iterator {
        protected final Object array;
        protected int i = 0;
        protected final int len;

        public ArrayIterator(Object src) {
            this.array = src;
            this.len = Array.getLength(src);
        }

        public boolean hasNext() {
            return this.i < this.len;
        }

        public Object next() {
            try {
                return Array.get(this.array, this.i++);
            }
            catch (ArrayIndexOutOfBoundsException ioob) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

