/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.bpmn.client.session;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.client.diagram.DiagramTypeService;
import org.kie.workbench.common.stunner.bpmn.client.workitem.WorkItemDefinitionClientRegistry;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class BPMNSessionInitializerTest {

    @Mock
    private WorkItemDefinitionClientRegistry workItemDefinitionService;

    private BPMNSessionInitializer tested;

    @Mock
    private DiagramTypeService diagramTypeService;

    @Before
    public void setUp() {
        tested = new BPMNSessionInitializer(workItemDefinitionService, diagramTypeService);
    }

    @Test
    public void testInit() {
        Metadata metadata = mock(Metadata.class);
        Command callback = mock(Command.class);
        tested.init(metadata, callback);
        verify(workItemDefinitionService, times(1)).load(eq(metadata), eq(callback));
        verify(diagramTypeService).loadDiagramType(metadata);
    }
}
