/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.InputStream;
import java.net.URL;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ResourceMetaImpl;
import org.apache.myfaces.shared.util.ClassUtils;

public class ClassLoaderResourceLoader
extends ResourceLoader {
    public ClassLoaderResourceLoader(String prefix) {
        super(prefix);
    }

    @Override
    public String getLibraryVersion(String path) {
        return null;
    }

    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        InputStream is = null;
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceMeta.getResourceIdentifier();
            is = this.getClassLoader().getResourceAsStream(name);
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(name);
            }
            return is;
        }
        is = this.getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(resourceMeta.getResourceIdentifier());
        }
        return is;
    }

    public URL getResourceURL(String resourceId) {
        URL url = null;
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            String name = this.getPrefix() + '/' + resourceId;
            url = this.getClassLoader().getResource(name);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
        url = this.getClassLoader().getResource(resourceId);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(resourceId);
        }
        return url;
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        return this.getResourceURL(resourceMeta.getResourceIdentifier());
    }

    @Override
    public String getResourceVersion(String path) {
        return null;
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return new ResourceMetaImpl(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    protected ClassLoader getClassLoader() {
        return ClassUtils.getContextClassLoader();
    }

    @Override
    public boolean libraryExists(String libraryName) {
        if (this.getPrefix() != null && !"".equals(this.getPrefix())) {
            URL url = this.getClassLoader().getResource(this.getPrefix() + '/' + libraryName);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(this.getPrefix() + '/' + libraryName);
            }
            if (url != null) {
                return true;
            }
        } else {
            URL url = this.getClassLoader().getResource(libraryName);
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(libraryName);
            }
            if (url != null) {
                return true;
            }
        }
        return false;
    }
}

