/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.wi.backend.server.workitem;

import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class ServiceTaskUtils {
    
    public static List<String> DEFAULT_HANDLERS = Arrays.asList("jbpm-workitems-webservice", 
                                                         "jbpm-workitems-rest", 
                                                         "jbpm-workitems-jms", 
                                                         "jbpm-workitems-email", 
                                                         "jbpm-workitems-bpmn2");

    public static String extractTargetInfo(String target) {
        URI uri = URI.create(target);        
        return uri.getHost() + uri.getPath();
    }
    
    
}
