package com.redhat.installer.layering.validator.container;

import org.osgi.framework.Version;

public class BasicVersionValidator implements VersionValidator {
    private final String minVersion;
    private final String maxVersion;

    public BasicVersionValidator(String minVersion, String maxVersion) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    @Override
    public String minSupportedVersion() {
        return minVersion;
    }

    @Override
    public String maxSupportedVersion() {
        return maxVersion;
    }

    @Override
    public VersionState validate(Version version) {
        Version minSupportedVersion = new Version(minVersion);
        Version maxSupportedVersion = new Version(maxVersion);

        if (version.compareTo(minSupportedVersion) < 0) {
            return VersionState.LowVersion;
        } else if (version.compareTo(maxSupportedVersion) > 0) {
            return VersionState.HighVersion;
        } else {
            return VersionState.OK;
        }
    }
}
