/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.impl.DefaultWebConfigProviderFactory;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class WebConfigProviderFactory {
    protected static final String FACTORY_DEFAULT = DefaultWebConfigProviderFactory.class.getName();
    private static final String FACTORY_KEY = WebConfigProviderFactory.class.getName();

    public static WebConfigProviderFactory getWebConfigProviderFactory(ExternalContext ctx) {
        WebConfigProviderFactory factory = (WebConfigProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (factory != null) {
            return factory;
        }
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                factory = (WebConfigProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, WebConfigProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                factory = (WebConfigProviderFactory)SpiUtils.build(ctx, WebConfigProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        if (factory != null) {
            WebConfigProviderFactory.setWebConfigProviderFactory(ctx, factory);
        }
        return factory;
    }

    public static void setWebConfigProviderFactory(ExternalContext ctx, WebConfigProviderFactory factory) {
        ctx.getApplicationMap().put(FACTORY_KEY, factory);
    }

    public abstract WebConfigProvider getWebConfigProvider(ExternalContext var1);
}

