package com.redhat.installer.tests.ports.validator;

import com.redhat.installer.asconfiguration.ports.validator.AddressValidator;
import com.redhat.installer.framework.mock.MockProcessingClient;
import com.redhat.installer.framework.testers.ValidatorTester;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

/**
 * Created by thauser on 2/3/14.
 */
public class AddressValidatorTest extends ValidatorTester {
    private String teststring;

    @Before
    public void setUp() throws Exception{
        v = new AddressValidator();
        mpc = new MockProcessingClient();
        mpc.addToFields("dummy"); // needed because of strange design of AddressValidator
    }

    @After
    public void tearDown() throws Exception{
        v = null;
        mpc = null;
    }

    @Test
    public void testValidIPv4Address() throws Exception{
        addTestIp("192.168.1.1", "testValidIPv4Address()");
        assertOkResult();
    }

    @Test
    public void testInvalidIPv4Address() throws Exception {
        addTestIp("192.300.1.1", "testInvalidIPv4Address()");
        assertErrorResult();
    }

    @Test
    public void testValidIPv6AddressIPv4Canonical() throws Exception {
        addTestIp("::ffff:192.168.1.1", "testValidIPv6AddressIPv4Canonical()");
        assertOkResult();
    }

    @Test
    public void testInvalidIPv6AddressIPv4Canonical() throws Exception {
        addTestIp("::ffff:192.300.1.1", "testInvalidIPv6AddressIPv4Canonical()");
        assertErrorResult();
    }

    @Test
    public void testValidFullIPv6Address() throws Exception {
        addTestIp("FE80:0000:0000:0000:0202:00FF:FE1E:8329", "testValidFullIPv6Address()");
        assertOkResult();
    }

    @Test
    public void testInvalidFullIPv6Address() throws Exception{
        addTestIp("FE80:0000:0000:0000:0202:00FF:FE1E:832Q", "testInvalidFullIPv6Address()");
        assertErrorResult();
    }

    @Test
    public void testValidCollapsedIPv6Address() throws Exception {
        addTestIp("FE80::202:FF:FE1E:8329", "testValidCollapsedIPv6Address()");
        assertOkResult();
    }

    @Test
    public void testInvalidCollapsedIPv6Address() throws Exception {
        addTestIp("FE80::202:FF:FE1E:832Q", "testInvalidCollapsedIPv6Address()");
        assertErrorResult();
    }

    @Test
    public void testValidDomain() throws Exception {
        addTestIp("localhost", "testValidDoman()");
        assertOkResult();
    }

    @Test
    public void testInvalidDomain() throws Exception {
        addTestIp("superhouse", "testInvalidDomain()");
        assertErrorResult();
    }

    /**
     * http://tools.ietf.org/html/rfc6874
     * May require more extensive testing
     * @throws Exception
     */

    @Test
    public void testValidIPv6ZoneId() throws Exception {
        addTestIp("FE80::202:FF:FE1E:8329%eth0", "testValidIPv6ZoneId()");
        assertOkResult();
    }

    @Test
    public void testInvalidIPv6ZoneId() throws Exception {
        addTestIp("FE80::202:FF:FE1E:8329%%eth0", "testInvalidIPv6ZoneId()");
        assertErrorResult();
    }

    private void addTestIp(String ip, String methodname){
        teststring = ip;
        mpc.addToFields(ip);
        System.out.println(methodname + " : " + teststring);
    }
}
