package com.redhat.installer.asconfiguration.processpanel;


import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.EmbeddedServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommands;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.asconfiguration.ascontroller.ServerManager;
import com.redhat.installer.asconfiguration.processpanel.postinstallation.PostInstallation;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CliScriptHelper {
    private static EmbeddedServerCommands serverCommands;
    private static List<String> cliScripts;
    private static final String RESOLVE_PARAMS = "resolve-params";
    private static final String SCRIPT = "script";
    private static final String HAS_DEPLOY = "has-deploy";
    // ServerCommands to run the commands with
    private static ArgumentParser parser;
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;
    private static boolean hasDeployCommand;


    public static boolean run(AbstractUIProcessHandler handler, String[] args) throws Exception {
        return initializeStaticVariables(handler, args) && isCliScriptExecutionSuccessful();
    }

    private static boolean initializeStaticVariables(AbstractUIProcessHandler handler, String[] args) throws InterruptedException {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        parser = new ArgumentParser();
        parser.parse(args);
        cliScripts = parser.getListProperty(SCRIPT);
        hasDeployCommand = parser.hasProperty(HAS_DEPLOY) && Boolean.parseBoolean(parser.getStringProperty(HAS_DEPLOY));
        return allScriptsExist() && initializeServerCommands();
    }

    private static boolean allScriptsExist() {
        for (String script : cliScripts) {
            File check = new File(script);
            if (!check.exists()) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("CliScriptHelper.notexist"), check.getAbsolutePath()), true);
                return false;
            }
        }
        return true;
    }

    private static boolean initializeServerCommands() throws InterruptedException {
        serverCommands = PostInstallation.initServerCommands(CliScriptHelper.class);
        if (parser.hasProperty(RESOLVE_PARAMS)) {
            String resolution = parser.getStringProperty(RESOLVE_PARAMS);
            serverCommands.setResolveParameterValues(Boolean.parseBoolean(resolution));
        } else {
            serverCommands.setResolveParameterValues(true);
        }
        return true;
    }

    private static boolean isCliScriptExecutionSuccessful() {
        try {
            executeScripts();
        } catch (ScriptFailedException sfe) {
            printFailureMessage(sfe.getFailedScriptName(), sfe.getFailedScriptCommands());
            return false;
        } finally {
            serverCommands.closeLogHandlers();
        }
        return true;
    }

    private static boolean executeScripts() throws ScriptFailedException {
        for (String cliScript : cliScripts) {
            File cliScriptFile = new File(cliScript);
            List<String> commandList = ServerCommandsHelper.loadCommandsIntoList(cliScript, hasDeployCommand);
            List<ModelNode> cliScriptResults = serverCommands.runCommandsInList(commandList);
            List<ModelNode> failures = ServerCommandsHelper.findFailures(cliScriptResults);
            if (!failures.isEmpty()) {
                throw new ScriptFailedException(cliScriptFile.getAbsolutePath(), failures);
            } else {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("CliScriptHelper.success"), cliScriptFile.getAbsolutePath()), false);
            }
        }
        return true;
    }

    private static void printFailureMessage(String failedScriptName, List<ModelNode> failures) {
        ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("CliScriptHelper.failure"), failedScriptName), true);
        for (ModelNode failure : failures) {
            ProcessPanelHelper.printToLog(String.format(idata.langpack.getString("CliScriptHelper.command.failed"),  failure.asString()));
        }
    }

    private static class ScriptFailedException extends Exception {
        private String failedScriptName;
        private List<ModelNode> failures;
        ScriptFailedException(String failedScript, List<ModelNode> failures) {
            this.failedScriptName = failedScript;
            this.failures = failures;

        }
        String getFailedScriptName() {
            return failedScriptName;
        }

        List<ModelNode> getFailedScriptCommands() { return failures; }
    }
}
