package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

/**
 * @author thauser
 */

public class ServerVariableHelper extends PostInstallation {
    @Override
    protected Class getClassName() {
        return ServerVariableHelper.class;
    }

    @Override
    protected boolean performOperation() {
        return getServerVariableValues(arguments);
    }

    protected boolean getServerVariableValues(String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        for (int i = 0; i < args.length; i++) {
            if (!args[i].startsWith("--")) {
                ModelNode result = serverCommands.getModelNodeResult("/path=" + args[i] + ":read-attribute(name=path)");
                if (Operations.isSuccessfulOutcome(result)) {
                    String varValue = result.get("result").asString();
                    idata.setVariable(args[i], varValue);
                    ProcessPanelHelper.printToPanel(mHandler, args[i] + " = " + varValue, false);
                }
            }
        }
        return true;
    }
}
