package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.SetWarningDefault;
import com.redhat.installer.asconfiguration.utils.JarUtils;
import org.apache.tools.ant.taskdefs.Jar;

import java.io.IOException;
import java.util.jar.JarFile;
/**
 * Created by dsoukhov on 19/08/16.
 */
public class VerifyJsfProjectValidator implements DataValidator, SetWarningDefault {
    String formattedMessage;

    @Override
    public Status validateData(AutomatedInstallData adata) {
        String combinedMsg = adata.getVariable("jsf.validator.combined.msg");
        String currentTurn = adata.getVariable("jsf.to.validate.project");
        String jarTmpPath = adata.getVariable(currentTurn+".tmp");
        String jarPath = jarTmpPath == null? adata.getVariable(currentTurn) : jarTmpPath;

        if (currentTurn.contains("api")) {
            adata.setVariable("jsf.to.validate.project", "jsfimpl.input");
        } else {
            adata.setVariable("jsf.to.validate.project", "jsfapi.input");
        }

        String adataproj = adata.getVariable("jsf.project.name");

        if(jarPath == null||adataproj == null){
            setFormattedMessage(adata.langpack.getString("jsf.error.missing.xml.info"));
            return Status.ERROR;
        }

        try (JarFile jar = JarUtils.getJarFromPath(jarPath)) {
            Boolean isMojarra = getProjectFromPomAndManifest(jar, "mojarra");
            Boolean isMyfaces = getProjectFromPomAndManifest(jar, "myfaces");

            if(!isMojarra && !isMyfaces) { //unable to get project name
                if (adataproj.equals("auto")) {
                    setFormattedMessage(adata.langpack.getString("empty.fields.project"));
                    adata.setVariable("jsf.validator.combined.msg", "");
                    return Status.ERROR;
                }
                combinedMsg += (String.format(adata.langpack.getString("JBossJsfSetupPanel.error.manifest"), jarPath))+"\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                return Status.OK;
            }

            if(adataproj.equals("auto")){
                String proj = isMojarra? "Mojarra": "MyFaces";
                adata.setVariable("jsf.project.name", proj.toLowerCase());
                setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.setproject"), proj));
                return Status.WARNING;
            }

            if((adataproj.equals("mojarra") && isMyfaces) || adataproj.equals("myfaces") && isMojarra){
                combinedMsg +=(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.ProjectMatch"), jarPath))+"\n";
                adata.setVariable("jsf.validator.combined.msg", combinedMsg);
                return Status.OK;
            }

        } catch (IOException e) {
            setFormattedMessage(String.format(adata.langpack.getString("JBossJsfSetupPanel.error.JarError"), jarPath));
            adata.setVariable("jsf.validator.combined.msg", "");
            return Status.ERROR;
        }
        return Status.OK;
    }

    private boolean getProjectFromPomAndManifest(JarFile jar, String proj) throws IOException {
        boolean isProject;

        String value = proj.equals("myfaces") ? "myfaces-" : "jsf-";
        isProject = JarUtils.checkValueOfResource(jar, JarUtils.POM_PATH, "artifactId", value);

        isProject = !isProject ? JarUtils.checkValueOfResource(jar, JarUtils.MANIFEST_PATH, "Implementation-Title", proj): isProject;

        return isProject;
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return null;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public boolean warningDefault() {
        return true;
    }

    @Override
    public String getFormattedMessage() {
        return formattedMessage;
    }

    public void setFormattedMessage(String message) {
        formattedMessage = message;
    }

}