/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

final class PlasticFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean isKeyboardFocusEvent = true;

    PlasticFieldCaret() {
    }

    public void focusGained(FocusEvent e) {
        JTextComponent c;
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if ((c = this.getComponent()).isEnabled() && this.isKeyboardFocusEvent) {
            if (c instanceof JFormattedTextField) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        PlasticFieldCaret.super.setDot(0);
                        PlasticFieldCaret.super.moveDot(c.getDocument().getLength());
                    }
                });
            } else {
                super.setDot(0);
                super.moveDot(c.getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary()) {
            this.isKeyboardFocusEvent = true;
        }
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (e.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }
}

