alter table SessionInfo alter column id set data type bigint;
alter table AuditTaskImpl alter column processSessionId set data type bigint;
alter table AuditTaskImpl alter column activationTime set data type timestamp;
alter table AuditTaskImpl alter column createdOn set data type timestamp;
alter table AuditTaskImpl alter column dueDate set data type timestamp;
alter table ContextMappingInfo alter column KSESSION_ID set data type bigint;
alter table Task alter column processSessionId set data type bigint;

create table DeploymentStore (
    id bigint generated by default as identity,
    attributes varchar(255),
    DEPLOYMENT_ID varchar(255),
    deploymentUnit clob(65535),
    state integer,
    updateDate timestamp,
    primary key (id)
);

create unique index UK_DeploymentStore_1 on DeploymentStore (DEPLOYMENT_ID);

alter table ProcessInstanceLog add column processInstanceDescription varchar(255); 
alter table RequestInfo add column owner varchar(255);
alter table Task add column description varchar(255);
alter table Task add column name varchar(255);
alter table Task add column subject varchar(255);

-- update all tasks with its name, subject and description
update Task t set name = (select shortText from I18NText where Task_Names_Id = t.id);
update Task t set subject = (select shortText from I18NText where Task_Subjects_Id = t.id);
update Task t set description = (select shortText from I18NText where Task_Descriptions_Id = t.id);

INSERT INTO AuditTaskImpl (activationTime, actualOwner, createdBy, createdOn, deploymentId, description, dueDate, name, parentId, priority, processId, processInstanceId, processSessionId, status, taskId)
SELECT activationTime, actualOwner_id, createdBy_id, createdOn, deploymentId, description, expirationTime, name, parentId, priority,processId, processInstanceId, processSessionId, status, id 
FROM Task;

alter table TaskEvent add column workItemId bigint;
alter table TaskEvent add column processInstanceId bigint;
update TaskEvent t set workItemId = (select workItemId from Task where id = t.taskId);
update TaskEvent t set processInstanceId = (select processInstanceId from Task where id = t.taskId);