package com.redhat.installer.tests.layering.validator;

import com.izforge.izpack.Pack;
import com.izforge.izpack.util.OsConstraint;
import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.DataValidatorTester;
import com.redhat.installer.layering.validator.IsSupportedContainerValidator;
import com.redhat.installer.tests.TestUtils;
import org.junit.Before;
import org.junit.Test;

import java.util.ArrayList;

import static junit.framework.TestCase.assertEquals;

public class IsSupportedContainerValidatorTest extends DataValidatorTester {
    @Before
    public void before() throws Exception {
        dv = new IsSupportedContainerValidator();
        idata.langpack = TestUtils.createMockLangpack(tempFolder,
                "container.no.supported", "container.no.supported",
                "container.low.version", "container.low.version",
                "container.high.version", "container.high.version",
                "container.missing.version", "container.missing.version");
        idata.setVariable("eap.supported.version.major", "7");
        idata.setVariable("eap.supported.version.minor", "1");
        idata.setVariable("eap.supported.version.micro", "0");
        idata.setVariable("eap.supported.version.designation", "GA");
        idata.setVariable("eap.maximum.version.major", "8");
        idata.setVariable("eap.maximum.version.minor", "0");
        idata.setVariable("eap.maximum.version.micro", "0");
        idata.setVariable("jws.maximum.version.major", "8");
        idata.setVariable("jws.maximum.version.minor", "0");
        idata.setVariable("jws.maximum.version.micro", "0");
        Pack eapBCpack = new Pack("bc-eap", "bc-eap","bc",new ArrayList<OsConstraint>(),new ArrayList<String>(),false,false,false,"",false);
        Pack kieEE7pack = new Pack("kie-eap", "kie-eap","kie",new ArrayList<OsConstraint>(),new ArrayList<String>(),false,false,false,"",false);
        Pack kieJWSpack = new Pack("kie-jws", "kie-jws","kie-jws",new ArrayList<OsConstraint>(),new ArrayList<String>(),false,false,false,"",false);
        Pack controllerJWSpack= new Pack("cont", "cont","cont",new ArrayList<OsConstraint>(),new ArrayList<String>(),false,false,false,"",false);
        idata.allPacks = new ArrayList<>();
        idata.allPacks.add(eapBCpack);
        idata.allPacks.add(kieEE7pack);
        idata.allPacks.add(kieJWSpack);
        idata.allPacks.add(controllerJWSpack);
        idata.setVariable("INSTALL_PATH", tempFolder.getRoot().getAbsolutePath());
        idata.setVariable("product.name", "rhpam");
    }
/*
    @After
    public void tearDown() throws Exception {
        tempFolder.delete();
    }*/

    @Test
    public void  testNoSupportedContainer() throws Exception {
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
    }

    @Test
    public void testEapOkInstall() throws Exception {
        // construct fake eap install
        createEapInstallFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath() + "/version.txt");
        assertStatusOk();
        assertEquals("true", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
    }

    @Test
    public void testEapLowVersion() throws Exception {
        createEapInstallFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-low.txt", idata.getInstallPath() + "/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.low.version");
    }

    @Test
    public void testEapHighVersion() throws Exception {
        createEapInstallFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-high.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.high.version");
    }

    @Test
    public void testEapMissingVersion() throws Exception {
        createEapInstallFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-missing.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.missing.version");
    }

    @Test
    public void testRhbaEapExistingProduct() throws Exception {
        createEapInstallFiles();
        createRhbaEapProductFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testRhbaBothEapExistingProduct() throws Exception {
        createEapInstallFiles();
        createRhbaEapProductFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testRhdmEapExistingProduct() throws Exception {
        idata.setVariable("product.name", "rhdm");
        createEapInstallFiles();
        createRhdmEapProductFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testRhdmBothEapExistingProduct() throws Exception {
        idata.setVariable("product.name", "rhdm");
        createEapInstallFiles();
        createRhdmEapProductFiles();
        createEapKieProductFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testKieEapExistingProduct() throws Exception {
        createEapInstallFiles();
        createEapKieProductFiles();
        MockResourceBuilder.copyResourceToInstall("/eap/eap-version-ok.txt", idata.getInstallPath()+"/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testTomcatOk() throws Exception {
        createTomcatInstallFiles();
        MockResourceBuilder.copyExecutableToInstall("/tomcat/version-ok.sh", idata.getInstallPath()+"/bin/version.sh");
        assertStatusOk();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("true", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
    }

    @Test
    public void testTomcatLowVersion() throws Exception {
        createTomcatInstallFiles();
        MockResourceBuilder.copyExecutableToInstall("/tomcat/version-low.sh", idata.getInstallPath()+"/bin/version.sh");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.low.version");
    }

    @Test
    public void testTomcatHighVersion() throws Exception {
        createTomcatInstallFiles();
        MockResourceBuilder.copyExecutableToInstall("/tomcat/version-high.sh", idata.getInstallPath()+"/bin/version.sh");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.high.version");
    }

    @Test
    public void testTomcatEnvironmentVariableIgnore() throws Exception {
        createTomcatInstallFiles();
        MockResourceBuilder.copyExecutableToInstall("/tomcat/version-badenv.sh", idata.getInstallPath()+"/bin/version.sh");
        assertStatusOk();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("true", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
    }

    @Test
    public void testTomcatMissingVersion() throws Exception {
        createTomcatInstallFiles();
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.missing.version");
        // no version.sh
    }

    @Test
    public void testTomcatBothExistingProducts() throws Exception {
        createTomcatInstallFiles();
        createTomcatKieFiles();
        createTomcatControllerFiles();
        MockResourceBuilder.copyResourceToInstall("/tomcat/version-ok.sh", idata.getInstallPath()+"/bin/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    @Test
    public void testTomcatKieExistingProduct() throws Exception {
        createTomcatInstallFiles();
        createTomcatKieFiles();
        MockResourceBuilder.copyResourceToInstall("/tomcat/version-ok.sh", idata.getInstallPath()+"/bin/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }


    @Test
    public void testTomcatControllerExistingProduct() throws Exception {
        createTomcatInstallFiles();
        createTomcatControllerFiles();
        MockResourceBuilder.copyResourceToInstall("/tomcat/version-ok.sh", idata.getInstallPath()+"/bin/version.txt");
        assertStatusError();
        assertEquals("false", idata.getVariable("eap.install"));
        assertEquals("false", idata.getVariable("jws.install"));
        assertEquals("false", idata.getVariable("weblogic.install"));
        assertEquals("false", idata.getVariable("websphere.install"));
        assertLangpack("container.product.already.installed");
    }

    private void createEapInstallFiles() throws Exception{
        tempFolder.newFolder("standalone");
        tempFolder.newFolder("standalone/configuration");
        tempFolder.newFolder("standalone/deployments/");
        tempFolder.newFile("standalone/configuration/standalone.xml");
        tempFolder.newFile("standalone/configuration/standalone-ha.xml");
        tempFolder.newFile("standalone/configuration/standalone-full.xml");
        tempFolder.newFile("standalone/configuration/standalone-full-ha.xml");

        tempFolder.newFolder("domain");
        tempFolder.newFolder("domain/configuration");
        tempFolder.newFile("domain/configuration/domain.xml");
        tempFolder.newFile("domain/configuration/host.xml");

        tempFolder.newFolder("bin");
        tempFolder.newFile("bin/add-user.sh");
    }

    private void createRhbaEapProductFiles() throws Exception {
        tempFolder.newFile("standalone/deployments/business-central.war");
    }

    private void createRhdmEapProductFiles() throws Exception {
        tempFolder.newFile("standalone/deployments/decision-central.war");
    }

    private void createEapKieProductFiles() throws Exception {
        tempFolder.newFile("standalone/deployments/kie-server.war");
    }

    private void createTomcatInstallFiles() throws Exception {
        tempFolder.newFolder("lib");
        tempFolder.newFolder("bin");
        tempFolder.newFolder("webapps");

        tempFolder.newFolder("conf");
        tempFolder.newFile("conf/context.xml");
        tempFolder.newFile("conf/server.xml");
        tempFolder.newFile("conf/tomcat-users.xml");
    }

    private void createTomcatKieFiles() throws Exception {
        tempFolder.newFolder("webapps/kie-server");
    }

    private void createTomcatControllerFiles() throws Exception {
        tempFolder.newFolder("webapps/controller");
    }
}
