package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;
import com.redhat.installer.installation.util.TomcatUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TomcatAddDataSource {
    private static AutomatedInstallData idata;
    private static AbstractUIProcessHandler mHandler;

    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        idata = AutomatedInstallData.getInstance();
        mHandler = handler;
        return addTomcatDataSource(args);
    }

    private static boolean addTomcatDataSource(String[] args) {
        try{
            Document xml = TomcatUtils.getContextXmlDocument();
            xml.getDocumentElement().appendChild(TomcatUtils.createInstallerComment(xml));
            addDatasourceResourceToContext(xml, args);
            TomcatUtils.writeXmlDocumentToFile(xml, TomcatUtils.getContextPath());
        } catch (SAXException | ParserConfigurationException | IOException | TransformerException | XPathExpressionException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.datasource.failed"), true);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.datasource.success"), false);
        return true;
    }

    private static void addDatasourceResourceToContext(Document xml, String[] args) {
        Element resource = xml.createElement("Resource");
        Map<String,String> resourceAttributes = createResourceAttributesMap(args);
        for (Map.Entry<String,String> attribute : resourceAttributes.entrySet()){
            resource.setAttribute(attribute.getKey(), attribute.getValue());
        }
        xml.getDocumentElement().appendChild(resource);
    }

    private static Map<String, String> createResourceAttributesMap(String[] args) {
        Map<String,String> attributeMap = new HashMap<>();
        for (String keyvalue : args){
            String[] split = keyvalue.split("=");
            attributeMap.put(split[0], split[1]);
        }
        attributeMap.put("driverClassName", JBossJDBCConstants.classnameMap.get(idata.getVariable("jdbc.driver.name")));
        return attributeMap;
    }

}
