package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import org.jboss.dmr.ModelNode;

import java.util.ArrayList;
import java.util.List;

public class Ldap extends PostInstallation {

    @Override
    protected Class getClassName() {
        return Ldap.class;
    }

    @Override
    protected boolean performOperation() {
        return installLdap();
    }

    protected static boolean installLdap() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String ldapName = idata.getVariable("ldap.name");
        String ldapUrl = idata.getVariable("ldap.url");
        String ldapDn = idata.getVariable("ldap.dn");
        String ldapPlainPwd = idata.getVariable("ldap.password");
        String ldapVaultedPwd = idata.getVariable("ldap.vaulted.password");
        String ldapPwd = (ldapVaultedPwd != null) ? ldapVaultedPwd : ldapPlainPwd;
        String ldapRealmName = idata.getVariable("ldap.realmname");
        String ldapBaseDn = idata.getVariable("ldap.basedn");
        String ldapRecursive = idata.getVariable("ldap.recursive");
        boolean ldapFilterType = idata.getVariable("ldap.filtertype") != null && idata.getVariable("ldap.filtertype").equals("advanced");
        String ldapFilter = idata.getVariable("ldap.filter");
        boolean result = serverCommands.installLdap(ldapName, ldapPwd, ldapUrl, ldapDn,
                ldapRealmName, ldapBaseDn, ldapFilter, ldapRecursive,
                ldapFilterType);
        boolean installSsl = idata.getVariable("installSsl") != null && Boolean.parseBoolean(idata.getVariable("installSsl"));
        if (installSsl) {
            String keystore = idata.getVariable("ssl.path");
            String keystorePassword = idata.getVariable("ssl.password");
            result = result && serverCommands.installSsl(keystore, keystorePassword, ldapRealmName);
        }
        if (!result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ldap.install.error"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.ldap.install.success"), false);
        }
        return result;
    }
}
