package com.redhat.installer.asconfiguration.jsf;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.MultiMessageValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.utils.JarUtils;

/**
 * Created by dsoukhov on 15/08/16.
 */
public class JsfJarsExistsValidator implements Validator, MultiMessageValidator{

    public String formatedMessage;
    AutomatedInstallData adata = AutomatedInstallData.getInstance();


    @Override
    public Status validate(ProcessingClient client) {
        if (!validJarPath(client.getText(), adata.langpack)) {
            return Status.ERROR;
        }
        return Status.OK;
    }

    public String getMessage() {
        return formatedMessage;
    }

    public void setFormattedMessage(String message) {

        formatedMessage = message;
    }
    private boolean validJarPath (String jarPath, LocaleDatabase langpack) {
        switch(JarUtils.verifyJarPath(jarPath)){
            case 0: // jar is fine
                break;
            case 1: // given path doesn't exist (or is directory)
                setFormattedMessage(String.format(langpack.getString("Jsf.path.error"), jarPath));
                return false;
            case 2: // given path isn't a zip
                setFormattedMessage(String.format(langpack.getString("Jsf.path.notzip"), jarPath));
                return false;
            case 3: // given path is a zip, but an empty one
                setFormattedMessage(String.format(langpack.getString("Jsf.path.emptyzip"), jarPath));
                return false;
            case 4: // given remote location isn't reachable
                setFormattedMessage(String.format(langpack.getString("Jsf.path.remote.error"), jarPath));
                return false;
            case 5:
                setFormattedMessage(String.format(langpack.getString("Jsf.path.exception.error"), jarPath));
                return false;
        }
        return true;
    }
}
