/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Map;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.ShadeColorScheme;
import org.jvnet.substance.color.ShiftColorScheme;
import org.jvnet.substance.color.TintColorScheme;
import org.jvnet.substance.color.ToneColorScheme;
import org.jvnet.substance.utils.SoftHashMap;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class InnerDelegateBorderPainter
implements SubstanceBorderPainter {
    protected String painterName;
    protected SubstanceBorderPainter delegate;
    protected float shiftCoef;
    protected SubstanceConstants.ColorShiftKind shiftKind;
    protected static Map<String, ColorScheme> shiftMap = new SoftHashMap<String, ColorScheme>();

    public InnerDelegateBorderPainter(String painterName, SubstanceBorderPainter delegate) {
        this(painterName, delegate, 0.7f, SubstanceConstants.ColorShiftKind.TINT);
    }

    public InnerDelegateBorderPainter(String painterName, SubstanceBorderPainter delegate, float shiftCoef, SubstanceConstants.ColorShiftKind shiftKind) {
        this.painterName = painterName;
        this.delegate = delegate;
        this.shiftCoef = shiftCoef;
        this.shiftKind = shiftKind;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public void paintBorder(Graphics g, Component comp, int width, int height, Shape contour, Shape innerContour, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        if (innerContour != null) {
            this.delegate.paintBorder(g, comp, width, height, innerContour, null, InnerDelegateBorderPainter.getShiftScheme(colorScheme1, this.shiftCoef, this.shiftKind), InnerDelegateBorderPainter.getShiftScheme(colorScheme2, this.shiftCoef, this.shiftKind), cyclePos, useCyclePosAsInterpolation);
        }
        this.delegate.paintBorder(g, comp, width, height, contour, null, colorScheme1, colorScheme2, cyclePos, useCyclePosAsInterpolation);
    }

    private static synchronized ColorScheme getShiftScheme(ColorScheme orig, float shiftCoef, SubstanceConstants.ColorShiftKind shiftKind) {
        String key = SubstanceCoreUtilities.getSchemeId(orig) + ":" + shiftCoef + ":" + shiftKind.name();
        if (!shiftMap.containsKey(key)) {
            switch (shiftKind) {
                case TINT: {
                    shiftMap.put(key, new TintColorScheme(orig, shiftCoef));
                    break;
                }
                case TONE: {
                    shiftMap.put(key, new ToneColorScheme(orig, shiftCoef));
                    break;
                }
                case SHADE: {
                    shiftMap.put(key, new ShadeColorScheme(orig, shiftCoef));
                    break;
                }
                case THEME_LIGHT: {
                    shiftMap.put(key, new ShiftColorScheme(orig, orig.getUltraLightColor().brighter(), shiftCoef));
                }
            }
        }
        return shiftMap.get(key);
    }

    public SubstanceBorderPainter getDelegate() {
        return this.delegate;
    }
}

