/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES;
    private Map<ValidatorInfo, String> validators;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        if (this.validators == null) {
            this.validators = new HashMap<ValidatorInfo, String>();
        }
        FacesValidator validatorAnnotation = (FacesValidator)annotation;
        String value = ((FacesValidator)annotation).value();
        if (null == value || 0 == value.length()) {
            value = target.getSimpleName();
            value = Character.toLowerCase(value.charAt(0)) + value.substring(1);
        }
        ValidatorInfo info = new ValidatorInfo(value, validatorAnnotation.isDefault());
        this.validators.put(info, target.getName());
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.validators != null) {
            Application app = ctx.getApplication();
            for (Map.Entry<ValidatorInfo, String> entry : this.validators.entrySet()) {
                app.addValidator(entry.getKey().validatorId, entry.getValue());
                if (!entry.getKey().isDefault) continue;
                app.addDefaultValidatorId(entry.getKey().validatorId);
            }
        }
    }

    static {
        ArrayList<Class<FacesValidator>> handles = new ArrayList<Class<FacesValidator>>(1);
        handles.add(FacesValidator.class);
        HANDLES = Collections.unmodifiableCollection(handles);
    }

    private static class ValidatorInfo {
        final String validatorId;
        final boolean isDefault;

        ValidatorInfo(String validatorId, boolean isDefault) {
            this.validatorId = validatorId;
            this.isDefault = isDefault;
        }
    }
}

