/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.plugin.event;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.ext.plugin.model.PluginType;

@Portable
public class PluginUnregistered {

    private final String name;

    private final PluginType type;

    public PluginUnregistered(@MapsTo("name") final String name,
                              @MapsTo("type") final PluginType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public PluginType getType() {
        return type;
    }
}
