##Uberfire Javascript API's
Uberfire has a group of JavaScript APIs that allows the extensibility of the workbench. These APIs are automatically loaded into the workbench if they are placed in the "plugins" directory of your webapp. They can also be executed via a normal Javascript call.

This section will demonstrate the power of this API through examples.

###JS Perspectives

The **Perspective** API allows dynamic creation of perspectives.
```
$registerPerspective({
    id: "Home",
    is_default: true,
    panel_type: "org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter",
    view: {
        parts: [
            {
                place: "welcome",
                min_height: 100,
                parameters: {}
            }
        ],
        panels: [
            {
                width: 250,
                min_width: 200,
                position: "west",
                panel_type: "org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter",
                parts: [
                    {
                        place: "YouTubeVideos",
                        parameters: {}
                    }
                ]
            },
            {
                position: "east",
                panel_type: "org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter",
                parts: [
                    {
                        place: "TodoListScreen",
                        parameters: {}
                    }
                ]
            },
            {
                height: 400,
                position: "south",
                panel_type: "org.uberfire.client.workbench.panels.impl.MultiTabWorkbenchPanelPresenter",
                parts: [
                    {
                        place: "YouTubeScreen",
                        parameters: {}
                    }
                ]
            }
        ]
    }
});
```
###JS Editor

The **Editor** API allows dynamic creation of editors and their association with one or more file types.

```
$registerEditor({
    "id": "sample editor",
    "type": "editor",
    "templateUrl": "editor.html",
    "resourceType": "org.uberfire.client.workbench.type.AnyResourceType",
    "on_concurrent_update":function(){
        alert('on_concurrent_update callback')
        $vfs_readAllString(document.getElementById('filename').innerHTML, function(a) {
            document.getElementById('editor').value= a;
        });
    },
    "on_startup": function (uri) {
        $vfs_readAllString(uri, function(a) {
            alert('sample on_startup callback')
        });
    },
    "on_open":function(uri){
        $vfs_readAllString(uri, function(a) {
            document.getElementById('editor').value=a;
        });
        document.getElementById('filename').innerHTML = uri;
    }
});
```
Note that in addition to making an editor pluggable, certain workbench events can be hooked to a JS callback using the **Editor** API.
The example above registers handlers for two event types: **on_startup** and **on_open**.
There are also many more Uberfire lifecycle events available to Editors:

* on_concurrent_update;
* on_concurrent_delete;
* on_concurrent_rename;
* on_concurrent_copy;
* on_rename;
* on_delete;
* on_copy;
* on_update;
* on_open;
* on_close;
* on_focus;
* on_lost_focus;
* on_may_close;
* on_startup;
* on_shutdown;


An editor is displayed via an html template, like in this example:

```
<div id="sampleEditor">
    <p>Sample JS editor (generated by editor-sample.js)</p>
    <textarea id="editor"></textarea>

    <p>Current file:</p><span id="filename"></span>
    <button id="save" type="button" onclick="$vfs_write(document.getElementById('filename').innerHTML, document.getElementById('editor').value,  function(a) {});">Save</button>
    <br>

    <p>This button change the file content, and uberfire send a callback to the editor:</p>
    <button id="reset" type="button" onclick="$vfs_write(document.getElementById('filename').innerHTML, 'Something else',  function(a) {});">Reset File</button>
</div>

```
###JS PlaceManager
The Uberfire **PlaceManager** API allows your app to programmatically "go to" a specific workbench component. The "go to" action requests the workbench to display the component associated with some target.
```
$goToPlace("componentIdentifier");
```
###Register Plugin API
The **Register plugin** API creates dynamic plugins (that will be transformed into workbench screens) via a JS API.
```
$registerPlugin({
    id: "my_angular_js",
    type: "angularjs",
    templateUrl: "angular.sample.html",
    title: function () {
        return "angular " + Math.floor(Math.random() * 10);
    },
    on_close: function () {
        alert("this is a pure JS alert!");
    }
});
```
Each plugin also has an html template:
```
File: angular.sample.html
<div ng-controller="TodoCtrl">
    <span>{{remaining()}} of {{todos.length}} remaining</span>
    [ <a href="" ng-click="archive()">archive</a> ]
    <ul class="unstyled">
        <li ng-repeat="todo in todos">
            <input type="checkbox" ng-model="todo.done">
            <span class="done-{{todo.done}}">{{todo.text}}</span>
        </li>
    </ul>
    <form ng-submit="addTodo()">
        <input type="text" ng-model="todoText" size="30" placeholder="add new todo here">
        <input class="btn-primary" type="submit" value="add">
    </form>
    <form ng-submit="goto()">
        <input type="text" ng-model="placeText" size="30" placeholder="place to go">
        <input class="btn-primary" type="submit" value="goTo">
    </form>
</div>
```
A plugin can be hooked to workbench events via these JS callbacks:

* on_concurrent_update;
* on_concurrent_delete;
* on_concurrent_rename;
* on_concurrent_copy;
* on_rename;
* on_delete;
* on_copy;
* on_update;
* on_open;
* on_close;
* on_focus;
* on_lost_focus;
* on_may_close;
* on_startup;
* on_shutdown;

###JS Splash Screens

**Splash Screens** can also be created via a JS API.

```
$registerSplashScreen({
    id: "home.splash",
    templateUrl: "home.splash.html",
    body_height: 325,
    title: function () {
        return "Cool Home Splash " + Math.floor(Math.random() * 10);
    },
    display_next_time: true,
    interception_points: ["Home"]
});
```

###JS Virtual File System (VFS)
The **VFS**  API allows you to read and write files asynchronously.
```
$vfs_readAllString(uri,  function(a) {
         //callback logic
    });

$vfs_write(uri,content,  function(a) {
        //callback logic
	})
```
