/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.stunner.core.client.session;

import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.graph.Element;

/**
 * A session that provides controls which do not update or modify the session's diagram structure/metadata.
 * Any read only session instance must provide at least two controls - zoom control and pan control.
 * Implementation can provide additional controls.
 * @param <C> The canvas.
 * @param <H> The canvas handler.
 */
public interface ClientReadOnlySession<C extends Canvas, H extends CanvasHandler>
        extends ClientSession<C, H> {

    SelectionControl<H, Element> getSelectionControl();

    ZoomControl<C> getZoomControl();

    PanControl<C> getPanControl();
}
