package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.FileDownloader;
import com.izforge.izpack.util.Shell;

import java.util.Arrays;

/**
 * Created by dsoukhov on 21/04/17.
 */
public class FileDownloadManagerConsoleHelper {

    private String url;
    private FileDownloader fd;
    private String outputPath;
    private String cancelTip;
    private String spaces;
    private boolean result;
    private AutomatedInstallData data;

    public FileDownloadManagerConsoleHelper(String url) {

        fd = new FileDownloader(new DownloadHandlerConsole(), url);
        data = AutomatedInstallData.getInstance();
        this.url = url;
        cancelTip = " ["+data.langpack.getString("filedownloader.download.cancel")+"]";
        char[] chars = new char[cancelTip.length()];
        Arrays.fill(chars, ' ');
        spaces = new String(chars);
        if (fd.getResult()) {
            fd.start();
            initializePanel();
        }
    }

    public boolean getResult() {
        return result;
    }

    public String getDownloadPath() {
        return outputPath;
    }

    private void initializePanel() {
        outputPath = fd.getPath();
        System.out.println(String.format(data.langpack.getString("filedownloader.downloading"), url, outputPath));
        Thread getInputThread = new Thread(new Runnable() {
            @Override
            public void run() {
                Shell console = Shell.getInstance();
                while (fd.isDownloading()) {
                    try {
                        String input = console.getInputInterruptable(false);
                        if (input.equalsIgnoreCase("c")) {
                            System.out.println();
                            fd.stopDownload();
                            return;
                        }
                    } catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        });
        getInputThread.start();
        synchronized (fd) {
            try {
                // wait for the filedownloader to complete the download (or be cancelled)
                while (fd.isDownloading()) {
                    fd.wait();
                }
                // download is done; stop trying to read userinput
                getInputThread.interrupt();
            } catch (InterruptedException ie) {
            }
        }
    }

    private class DownloadHandlerConsole implements com.izforge.izpack.util.AbstractUIProgressHandler {
        int prevStep;

        @Override
        public void emitNotification(String message) {
        }

        @Override
        public boolean emitWarning(String title, String message) {
            return false;
        }

        @Override
        public void emitError(String title, String message) {
            System.out.println(message);
        }

        @Override
        public void emitErrorAndBlockNext(String title, String message) {
        }

        @Override
        public int askQuestion(String title, String question, int choices) {
            return 0;
        }

        @Override
        public int askQuestion(String title, String question, int choices, int default_choice) {
            return 0;
        }

        @Override
        public void startAction(String name, int no_of_steps) {
        }

        @Override
        public void stopAction() {
            result = fd.getResult();
        }

        @Override
        public void nextStep(String step_name, int step_no, int no_of_substeps) {

        }

        @Override
        public void setSubStepNo(int no_of_substeps) {

        }

        @Override
        public void progress(int substep_no, String message) {
            if (prevStep != substep_no) {
                prevStep = substep_no;
                if (substep_no == 100) {
                    System.out.println("\r" + message + spaces);
                } else {
                    System.out.print("\r" + message + String.format(cancelTip, substep_no));
                }
            }
        }
    }
}
