package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TomcatModifySetenv;
import com.redhat.installer.tests.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertTrue;

public class TomcatModifySetenvTest extends ProcessPanelTester {

    private final String existingSetenv = "/tomcat/setenv.sh";
    private final String copiedSetenv = "/bin/setenv.sh";
    private final String expectedText = "export CATALINA_OPTS=\"$CATALINA_OPTS -Xmx512M -Dorg.kie.server.id=tomcat-kieserver -Dorg.kie.server.location=http://localhost:8080/kie-server/services/rest/server -Dorg.kie.server.controller=http://localhost:8080/controller/rest/controller -Dorg.jbpm.server.ext.disabled=true -Dorg.jbpm.ui.server.ext.disabled=true -Dorg.jbpm.case.server.ext.disabled=true\"";


    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
    }

    @After
    public void cleanup() throws Exception {
        if (Files.exists(Paths.get(idata.getInstallPath() + copiedSetenv))) {
            MockResourceBuilder.deleteFile(idata.getInstallPath() + copiedSetenv);
        }
    }

    @Test
    public void testAppendSuccess() throws Exception {
        MockResourceBuilder.copyResourceToInstall(existingSetenv, idata.getInstallPath() + copiedSetenv);
        boolean result = TomcatModifySetenv.run(handler, new String[]{});
        assertCorrect(result);
    }

    @Test
    public void testCreateSuccess() throws Exception {
        tempFolder.newFolder("bin");
        boolean result = TomcatModifySetenv.run(handler, new String[]{});
        assertCorrect(result);
    }

    private void assertCorrect(boolean result) throws Exception {
        assertTrue(result);
        String fileContent = Files.lines(Paths.get(idata.getInstallPath() + copiedSetenv)).collect(Collectors.joining("\n"));
        assertTrue(fileContent.contains(expectedText));
    }
}
