package com.redhat.installer.tests.asconfiguration.action;

import com.redhat.installer.asconfiguration.action.SetBxmsUserRoles;
import com.redhat.installer.framework.testers.PanelActionTester;
import org.junit.Before;
import org.junit.Test;

import static junit.framework.TestCase.assertEquals;

public class SetBxmsUserRolesTest extends PanelActionTester {

    @Before
    public void before(){
        panelAction = new SetBxmsUserRoles();
    }

    @Test
    public void testSelectedRoles(){
        idata.setVariable("role.administrator", "false");
        idata.setVariable("role.kieserver", "true");
        idata.setVariable("role.restall", "false");
        idata.setVariable("role.analyst", "true");
        idata.setVariable("role.developer", "false");
        idata.setVariable("role.user", "true");
        idata.setVariable("role.manager", "false");
        idata.setVariable("role.processadmin", "true");
        panelAction.executeAction(idata, handler);
        assertEquals("kie-server,analyst,user,process-admin",idata.getVariable("user.final.roles"));
    }

    @Test
    public void testDefaultRoles(){
        idata.setVariable("role.administrator", "true");
        idata.setVariable("role.kieserver", "true");
        idata.setVariable("role.restall", "true");
        panelAction.executeAction(idata, handler);
        assertEquals("admin,kie-server,rest-all", idata.getVariable("user.final.roles"));
    }

    @Test
    public void testNoRoles(){
        idata.setVariable("role.administrator", "false");
        idata.setVariable("role.kieserver", "false");
        idata.setVariable("role.restall", "false");
        idata.setVariable("role.analyst", "false");
        idata.setVariable("role.developer", "false");
        idata.setVariable("role.user", "false");
        idata.setVariable("role.manager", "false");
        idata.setVariable("role.processadmin", "false");
        panelAction.executeAction(idata, handler);
        assertEquals("", idata.getVariable("user.final.roles"));
    }
}
