package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.DataValidator;
import org.apache.commons.lang.SystemUtils;

public class GitInPathValidator extends BinaryInPathValidator {
    @Override
    protected String getWarningId() {
        return "no.git.in.path.warning";
    }

    @Override
    protected String getBinaryName() {
        return SystemUtils.IS_OS_WINDOWS ? "git.exe" : "git";
    }

    @Override
    protected Status getFailureStatus() {
        return Status.WARNING;
    }
}
