<?xml version="1.0" encoding="UTF-8"?>
<!--
~ JBoss, Home of Professional Open Source.
~ Copyright 2011, Red Hat, Inc., and individual contributors
~ as indicated by the @author tags. See the copyright.txt file in the
~ distribution for a full listing of individual contributors.
~
~ This is free software; you can redistribute it and/or modify it
~ under the terms of the GNU Lesser General Public License as
~ published by the Free Software Foundation; either version 2.1 of
~ the License, or (at your option) any later version.
~
~ This software is distributed in the hope that it will be useful,
~ but WITHOUT ANY WARRANTY; without even the implied warranty of
~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
~ Lesser General Public License for more details.
~
~ You should have received a copy of the GNU Lesser General Public
~ License along with this software; if not, write to the Free
~ Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
~ 02110-1301 USA, or see the FSF site: http://www.fsf.org.
-->
<xsl:stylesheet version="2.0"
            xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            xmlns:xs="http://www.w3.org/2001/XMLSchema"
            xmlns:fn="http://www.w3.org/2005/xpath-functions"
            xmlns:xdt="http://www.w3.org/2005/xpath-datatypes"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:jb="urn:jboss:domain:5.0"
            exclude-result-prefixes="xs xsl xsi fn xdt jb cache-container">

   <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>

   <xsl:template match="node()[local-name(.) = 'session-bean'] ">
       <xsl:copy>
           <xsl:apply-templates select="node()|@*"/>
       </xsl:copy>
       <xsl:if test="ancestor::*[@name='default' or @name='ha']">
       <mdb xmlns="urn:jboss:domain:ejb3:5.0">
         <xsl:value-of disable-output-escaping='yes' select="concat('&lt;resource-adapter-ref resource-adapter-name=&quot;${ejb.resource-adapter-name:activemq-ra.rar}&quot; /&gt;')" />
         <bean-instance-pool-ref pool-name="mdb-strict-max-pool"/>
       </mdb>
       </xsl:if>
   </xsl:template>

   <xsl:template match="node()[local-name(.)='profile']">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>

         <xsl:if test="ancestor-or-self::*[@name='default' or @name='ha'] ">
	         <subsystem xmlns="urn:jboss:domain:messaging-activemq:1.0">
	            <server name="default">
	                <security-setting name="#">
	                    <role name="guest" delete-non-durable-queue="true" create-non-durable-queue="true" consume="true" send="true"/>
	                </security-setting>
	                <address-setting name="#" message-counter-history-day-limit="10" page-size-bytes="2097152" max-size-bytes="10485760" expiry-address="jms.queue.ExpiryQueue" dead-letter-address="jms.queue.DLQ"/>
	                <http-connector name="http-connector" endpoint="http-acceptor" socket-binding="http"/>
	                <http-connector name="http-connector-throughput" endpoint="http-acceptor-throughput" socket-binding="http">
	                    <param name="batch-delay" value="50"/>
	                </http-connector>
	                <in-vm-connector name="in-vm" server-id="0"/>
	                <http-acceptor name="http-acceptor" http-listener="default"/>
	                <http-acceptor name="http-acceptor-throughput" http-listener="default">
	                    <param name="batch-delay" value="50"/>
	                    <param name="direct-deliver" value="false"/>
	                </http-acceptor>
	                <in-vm-acceptor name="in-vm" server-id="0"/>
	                <jms-queue name="ExpiryQueue" entries="java:/jms/queue/ExpiryQueue"/>
	                <jms-queue name="DLQ" entries="java:/jms/queue/DLQ"/>
	                <connection-factory name="InVmConnectionFactory" entries="java:/ConnectionFactory" connectors="in-vm"/>
	                <connection-factory name="RemoteConnectionFactory" entries="java:jboss/exported/jms/RemoteConnectionFactory" connectors="http-connector"/>
	                <pooled-connection-factory name="activemq-ra" transaction="xa" entries="java:/JmsXA java:jboss/DefaultJMSConnectionFactory" connectors="in-vm"/>
	            </server>
            </subsystem>
         </xsl:if>
       </xsl:copy>
   </xsl:template>
</xsl:stylesheet>
