/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.services.backend.project;

import javax.enterprise.context.ApplicationScoped;

import org.guvnor.common.services.project.backend.server.ProjectResourcePathResolver;
import org.guvnor.common.services.project.model.Package;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class JavaFileProjectResourcePathResolver
        implements ProjectResourcePathResolver {

    public JavaFileProjectResourcePathResolver( ) {
        //Empty constructor for Weld proxying
    }

    @Override
    public int getPriority( ) {
        return 0;
    }

    @Override
    public boolean accept( String resourceType ) {
        return "java".equals( resourceType );
    }

    @Override
    public Path resolveDefaultPath( Package pkg ) {
        return pkg.getPackageMainSrcPath();
    }
}