package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

/**
 * Created by eunderhi on 18/08/15.
 */
public class LoggingLevel extends PostInstallation {

    private static final String CONSOLE_GROUP = "console-handler";
    private static final String ROOT_GROUP = "root-logger";

    private static boolean configureLoggingLevels(){
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String level = idata.getVariable("console-log-level");
        boolean result = isStandaloneFullHa()|| isDomain() || configureLoggingLevel(level, CONSOLE_GROUP);
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("LoggingLevel.console.log.level.failed"), true);
            return false;
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("LoggingLevel.console.log.level.success"), false);
        }
        level = idata.getVariable("root-log-level");
        result = configureLoggingLevel(level, ROOT_GROUP);
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("LoggingLevel.root.log.level.failed"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("LoggingLevel.root.log.level.success"), false);
        }

        return result;
    }

    private static boolean configureLoggingLevel(String level, String group) {
        return serverCommands.writeLoggingLevel(level, group);
    }

    private static boolean isStandaloneFullHa() {
        return arguments.length != 0 && arguments[0].equals("standalone-full-ha.xml");
    }

    private static boolean isDomain(){
        return arguments.length !=0 && arguments[0].equals("host.xml");
    }

    @Override
    protected Class getClassName() {
        return LoggingLevel.class;
    }

    @Override
    protected boolean performOperation() {
        return configureLoggingLevels();
    }
}
