/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is copy pasted to another package in the KieContainer test to avoid false positive tests
package testdata.kjar;

import java.util.Collection;
import java.util.List;

import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import testdata.kjar.ClassloadedTestdataEntity;
import testdata.kjar.ClassloadedTestdataValue;

@PlanningSolution
public class ClassloadedTestdataSolution implements Solution<SimpleScore> {

    public static SolutionDescriptor buildSolutionDescriptor() {
        return SolutionDescriptor.buildSolutionDescriptor(ClassloadedTestdataSolution.class, ClassloadedTestdataEntity.class);
    }

    private List<ClassloadedTestdataValue> valueList;
    private List<ClassloadedTestdataEntity> entityList;

    private SimpleScore score;

    public ClassloadedTestdataSolution() {
    }

    @ValueRangeProvider(id = "valueRange")
    public List<ClassloadedTestdataValue> getValueList() {
        return valueList;
    }

    public void setValueList(List<ClassloadedTestdataValue> valueList) {
        this.valueList = valueList;
    }

    @PlanningEntityCollectionProperty
    public List<ClassloadedTestdataEntity> getEntityList() {
        return entityList;
    }

    public void setEntityList(List<ClassloadedTestdataEntity> entityList) {
        this.entityList = entityList;
    }

    public SimpleScore getScore() {
        return score;
    }

    public void setScore(SimpleScore score) {
        this.score = score;
    }

    // ************************************************************************
    // Complex methods
    // ************************************************************************

    public Collection<? extends Object> getProblemFacts() {
        return valueList;
    }

}
