/*
 * Copyright 2013 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.otec.client;

import org.jboss.errai.otec.client.operation.OTOperation;

import java.util.List;
import java.util.Set;

/**
 * @author Mike Brock
 */
public class LogQuery {
  private final State effectiveState;
  private final Set<OTOperation> contingentOps;
  private final List<OTOperation> localOpsNeedsMerge;

  public LogQuery(State effectiveState, Set<OTOperation> contingentOps, List<OTOperation> localOpsNeedsMerge) {
    this.effectiveState = effectiveState;
    this.contingentOps = contingentOps;
    this.localOpsNeedsMerge = localOpsNeedsMerge;
  }

  public State getEffectiveState() {
    return effectiveState;
  }

  public Set<OTOperation> getContingentOps() {
    return contingentOps;
  }

  public List<OTOperation> getLocalOpsNeedsMerge() {
    return localOpsNeedsMerge;
  }
}
