/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.kie.server.controller.common;

import java.util.HashSet;
import java.util.Set;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

import org.kie.server.controller.rest.RestKieServerControllerAdminImpl;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.server.controller.rest.RestSpecManagementServiceImpl;

@ApplicationPath("/")
public class KieServerControllerApplication extends Application {

    @Override
    public Set<Class<?>> getClasses() {
        Set<Class<?>> classes = new HashSet<Class<?>>();
        classes.add(RestKieServerControllerImpl.class);
        classes.add(RestKieServerControllerAdminImpl.class);
        classes.add(RestSpecManagementServiceImpl.class);
        return classes;
    }
}
