/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.services.datamodeller.parser;

import org.junit.Test;
import org.kie.workbench.common.services.datamodeller.parser.descr.ClassDescr;
import org.kie.workbench.common.services.datamodeller.parser.descr.DescriptorFactoryImpl;
import org.kie.workbench.common.services.datamodeller.parser.descr.FieldDescr;
import org.kie.workbench.common.services.datamodeller.parser.util.ParserUtil;

import static org.junit.Assert.*;

public class JavaFileHandler2Test extends JavaFileHandlerBaseTest {

    String fileContents[] = new String[ 6 ];

    public JavaFileHandler2Test( ) throws Exception {
        super( "JavaFileHandler2.java" );
    }

    private void assertStrings( String a, String b ) {
        for ( int i = 0; i < a.length( ) && i < b.length( ); i++ ) {
            assertEquals( "character i: " + i + " expected: " + a.charAt( i ) + " current: " + b.length( ), a.charAt( i ), b.charAt( i ) );
        }
    }

    @Test
    public void test( ) {
        try {

            String result = fileHandler.buildResult( );
            System.out.println( result );

            ClassDescr classDescr = fileHandler.getFileDescr( ).getClassDescr( );

            FieldDescr field = DescriptorFactoryImpl.getInstance( ).createFieldDescr( "\n\n\tpublic /*eso*/static   int value  = (2+4), otro=1  /**/ ; /**/" );

            ParserUtil.setSourceBufferTMP( field, field.getSourceBuffer( ) );
            ParserUtil.populateUnManagedElements( 0, field.getSourceBuffer().length()-1, field );
            ParserUtil.setSourceBufferTMP( field, field.getSourceBuffer( ) );

            classDescr.addField( field );
            classDescr.addField( field );

            result = fileHandler.buildResult( );
            System.out.println( result );

            classDescr.getElements( ).remove( field );
            classDescr.getElements( ).remove( field );

            result = fileHandler.buildResult( );
            System.out.println( result );

            assertEquals( originalFileContent, result );
            int i = 0;

        } catch ( Exception e ) {
            e.printStackTrace( );
        }

    }

    @Test
    public void test2() {
        String value = "package org.kie.sourcepreservation1;\n" +
                "\n" +
                "/**\n" +
                " * This class was automatically generated by the data modeler tool.\n" +
                " * $HASH(9c8d3fc2e58c45e76730f31724eaeae9)\n" +
                " */\n" +
                "public class DefaultJavaTypes  implements java.io.Serializable {\n" +
                "\n" +
                "    static final long serialVersionUID = 1L;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 16)\n" +
                "    private java.math.BigDecimal o_BigDecimal;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 17)\n" +
                "    private java.math.BigInteger o_BigInteger;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 1)\n" +
                "    private java.lang.Boolean o_Boolean;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 3)\n" +
                "    private java.lang.Byte o_Byte;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 5)\n" +
                "    private java.lang.Character o_Character;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 18)\n" +
                "    private java.util.Date o_Date;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 7)\n" +
                "    private java.lang.Double o_Double;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 9)\n" +
                "    private java.lang.Float o_Float;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 11)\n" +
                "    private java.lang.Integer o_Integer;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 13)\n" +
                "    private java.lang.Long o_Long;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 15)\n" +
                "    private java.lang.Short o_Short;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 19)\n" +
                "    private java.lang.String o_String;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 0)\n" +
                "    private boolean p_boolean;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 2)\n" +
                "    private byte p_byte;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 4)\n" +
                "    private char p_char;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 6)\n" +
                "    private double p_double;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 8)\n" +
                "    private float p_float;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 10)\n" +
                "    private int p_int;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 12)\n" +
                "    private long p_long;\n" +
                "    \n" +
                "    @org.kie.api.definition.type.Position(value = 14)\n" +
                "    private short p_short;\n" +
                "\n" +
                "    public DefaultJavaTypes() {\n" +
                "    }\n" +
                "\n" +
                "    public DefaultJavaTypes(boolean p_boolean, java.lang.Boolean o_Boolean, byte p_byte, java.lang.Byte o_Byte, char p_char, java.lang.Character o_Character, double p_double, java.lang.Double o_Double, float p_float, java.lang.Float o_Float, int p_int, java.lang.Integer o_Integer, long p_long, java.lang.Long o_Long, short p_short, java.lang.Short o_Short, java.math.BigDecimal o_BigDecimal, java.math.BigInteger o_BigInteger, java.util.Date o_Date, java.lang.String o_String) {\n" +
                "        this.p_boolean = p_boolean;\n" +
                "        this.o_Boolean = o_Boolean;\n" +
                "        this.p_byte = p_byte;\n" +
                "        this.o_Byte = o_Byte;\n" +
                "        this.p_char = p_char;\n" +
                "        this.o_Character = o_Character;\n" +
                "        this.p_double = p_double;\n" +
                "        this.o_Double = o_Double;\n" +
                "        this.p_float = p_float;\n" +
                "        this.o_Float = o_Float;\n" +
                "        this.p_int = p_int;\n" +
                "        this.o_Integer = o_Integer;\n" +
                "        this.p_long = p_long;\n" +
                "        this.o_Long = o_Long;\n" +
                "        this.p_short = p_short;\n" +
                "        this.o_Short = o_Short;\n" +
                "        this.o_BigDecimal = o_BigDecimal;\n" +
                "        this.o_BigInteger = o_BigInteger;\n" +
                "        this.o_Date = o_Date;\n" +
                "        this.o_String = o_String;\n" +
                "    }\n" +
                "\n" +
                "\n" +
                "    \n" +
                "    public java.math.BigDecimal getO_BigDecimal() {\n" +
                "        return this.o_BigDecimal;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_BigDecimal(java.math.BigDecimal o_BigDecimal) {\n" +
                "        this.o_BigDecimal = o_BigDecimal;\n" +
                "    }\n" +
                "    \n" +
                "    public java.math.BigInteger getO_BigInteger() {\n" +
                "        return this.o_BigInteger;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_BigInteger(java.math.BigInteger o_BigInteger) {\n" +
                "        this.o_BigInteger = o_BigInteger;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Boolean getO_Boolean() {\n" +
                "        return this.o_Boolean;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Boolean(java.lang.Boolean o_Boolean) {\n" +
                "        this.o_Boolean = o_Boolean;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Byte getO_Byte() {\n" +
                "        return this.o_Byte;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Byte(java.lang.Byte o_Byte) {\n" +
                "        this.o_Byte = o_Byte;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Character getO_Character() {\n" +
                "        return this.o_Character;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Character(java.lang.Character o_Character) {\n" +
                "        this.o_Character = o_Character;\n" +
                "    }\n" +
                "    \n" +
                "    public java.util.Date getO_Date() {\n" +
                "        return this.o_Date;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Date(java.util.Date o_Date) {\n" +
                "        this.o_Date = o_Date;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Double getO_Double() {\n" +
                "        return this.o_Double;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Double(java.lang.Double o_Double) {\n" +
                "        this.o_Double = o_Double;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Float getO_Float() {\n" +
                "        return this.o_Float;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Float(java.lang.Float o_Float) {\n" +
                "        this.o_Float = o_Float;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Integer getO_Integer() {\n" +
                "        return this.o_Integer;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Integer(java.lang.Integer o_Integer) {\n" +
                "        this.o_Integer = o_Integer;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Long getO_Long() {\n" +
                "        return this.o_Long;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Long(java.lang.Long o_Long) {\n" +
                "        this.o_Long = o_Long;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.Short getO_Short() {\n" +
                "        return this.o_Short;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_Short(java.lang.Short o_Short) {\n" +
                "        this.o_Short = o_Short;\n" +
                "    }\n" +
                "    \n" +
                "    public java.lang.String getO_String() {\n" +
                "        return this.o_String;\n" +
                "    }\n" +
                "\n" +
                "    public void setO_String(java.lang.String o_String) {\n" +
                "        this.o_String = o_String;\n" +
                "    }\n" +
                "    \n" +
                "    public boolean isP_boolean() {\n" +
                "        return this.p_boolean;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_boolean(boolean p_boolean) {\n" +
                "        this.p_boolean = p_boolean;\n" +
                "    }\n" +
                "    \n" +
                "    public byte getP_byte() {\n" +
                "        return this.p_byte;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_byte(byte p_byte) {\n" +
                "        this.p_byte = p_byte;\n" +
                "    }\n" +
                "    \n" +
                "    public char getP_char() {\n" +
                "        return this.p_char;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_char(char p_char) {\n" +
                "        this.p_char = p_char;\n" +
                "    }\n" +
                "    \n" +
                "    public double getP_double() {\n" +
                "        return this.p_double;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_double(double p_double) {\n" +
                "        this.p_double = p_double;\n" +
                "    }\n" +
                "    \n" +
                "    public float getP_float() {\n" +
                "        return this.p_float;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_float(float p_float) {\n" +
                "        this.p_float = p_float;\n" +
                "    }\n" +
                "    \n" +
                "    public int getP_int() {\n" +
                "        return this.p_int;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_int(int p_int) {\n" +
                "        this.p_int = p_int;\n" +
                "    }\n" +
                "    \n" +
                "    public long getP_long() {\n" +
                "        return this.p_long;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_long(long p_long) {\n" +
                "        this.p_long = p_long;\n" +
                "    }\n" +
                "    \n" +
                "    public short getP_short() {\n" +
                "        return this.p_short;\n" +
                "    }\n" +
                "\n" +
                "    public void setP_short(short p_short) {\n" +
                "        this.p_short = p_short;\n" +
                "    }\n" +
                "}";


        String value2= "package org.kie.sourcepreservation1;\n" +
                "\n" +
                "/**\n" +
                " * This class was automatically generated by the data modeler tool.\n" +
                " * $HASH(9c8d3fc2e58c45e76730f31724eaeae9)\n" +
                " */\n" +
                "public class DefaultJavaTypes  implements java.io.Serializable {\n" +
                "\n" +
                " public int valor ( int a, int b) {"+
                " return 1; }"+
                "    public DefaultJavaTypes() {\n" +
                "    }\n" +
                "\n" +
                "    public DefaultJavaTypes(boolean p_boolean, java.lang.Boolean o_Boolean, byte p_byte, java.lang.Byte o_Byte, char p_char, java.lang.Character o_Character, double p_double, java.lang.Double o_Double, float p_float, java.lang.Float o_Float, int p_int, java.lang.Integer o_Integer, long p_long, java.lang.Long o_Long, short p_short, java.lang.Short o_Short, java.math.BigDecimal o_BigDecimal, java.math.BigInteger o_BigInteger, java.util.Date o_Date, java.lang.String o_String) {\n" +
                "        this.p_boolean = p_boolean;\n" +
                "        this.o_Boolean = o_Boolean;\n" +
                "        this.p_byte = p_byte;\n" +
                "        this.o_Byte = o_Byte;\n" +
                "        this.p_char = p_char;\n" +
                "        this.o_Character = o_Character;\n" +
                "        this.p_double = p_double;\n" +
                "        this.o_Double = o_Double;\n" +
                "        this.p_float = p_float;\n" +
                "        this.o_Float = o_Float;\n" +
                "        this.p_int = p_int;\n" +
                "        this.o_Integer = o_Integer;\n" +
                "        this.p_long = p_long;\n" +
                "        this.o_Long = o_Long;\n" +
                "        this.p_short = p_short;\n" +
                "        this.o_Short = o_Short;\n" +
                "        this.o_BigDecimal = o_BigDecimal;\n" +
                "        this.o_BigInteger = o_BigInteger;\n" +
                "        this.o_Date = o_Date;\n" +
                "        this.o_String = o_String;\n" +
                "    }\n" +
                "\n" +
                "}";

        String value3= "package org.kie.sourcepreservation1;\n" +
                "\n" +
                "/**\n" +
                " * This class was automatically generated by the data modeler tool.\n" +
                " * $HASH(9c8d3fc2e58c45e76730f31724eaeae9)\n" +
                " */\n" +
                "public class DefaultJavaTypes  implements java.io.Serializable {\n" +
                "\n" +
                "    static final long serialVersionUID = 1L;\n" +
                "    \n" +
                "        \n" +
                "    /*@org.kie.api.definition.type.Position(value = 14)*/\n" +
                "    /*private short p_short;*/\n" +
                "\n" +
                "    public DefaultJavaTypes() {\n" +
                "    }\n" +
                "\n" +
                "    public DefaultJavaTypes(boolean p_boolean, java.lang.Boolean o_Boolean, byte p_byte, java.lang.Byte o_Byte, char p_char, java.lang.Character o_Character, double p_double, java.lang.Double o_Double, float p_float, java.lang.Float o_Float, int p_int, java.lang.Integer o_Integer, long p_long, java.lang.Long o_Long, short p_short, java.lang.Short o_Short, java.math.BigDecimal o_BigDecimal, java.math.BigInteger o_BigInteger, java.util.Date o_Date, java.lang.String o_String) {\n" +
                "        this.p_boolean = p_boolean;\n" +
                "        this.o_Boolean = o_Boolean;\n" +
                "        this.p_byte = p_byte;\n" +
                "        this.o_Byte = o_Byte;\n" +
                "        this.p_char = p_char;\n" +
                "        this.o_Character = o_Character;\n" +
                "        this.p_double = p_double;\n" +
                "        this.o_Double = o_Double;\n" +
                "        this.p_float = p_float;\n" +
                "        this.o_Float = o_Float;\n" +
                "        this.p_int = p_int;\n" +
                "        this.o_Integer = o_Integer;\n" +
                "        this.p_long = p_long;\n" +
                "        this.o_Long = o_Long;\n" +
                "        this.p_short = p_short;\n" +
                "        this.o_Short = o_Short;\n" +
                "        this.o_BigDecimal = o_BigDecimal;\n" +
                "        this.o_BigInteger = o_BigInteger;\n" +
                "        this.o_Date = o_Date;\n" +
                "        this.o_String = o_String;\n" +
                "    }\n" +
                "}";
        try {
            JavaFileHandler f = JavaFileHandlerFactory.getInstance().newHandler( value2 );
            String out = f.buildResult();
            assertEquals( value2, out );
            int i = 0;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
