package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.processpanel.ArgumentParser;
import org.jboss.dmr.ModelNode;

import java.util.List;

/**
 * Deploys an artifact onto the currently running server
 * Created by thauser on 7/8/15.
 */
public class DeployArtifact extends PostInstallation {
    private static final String ARTIFACT_PATH = "path";

    public static boolean run(AbstractUIProcessHandler handler, String[]args){
        try {
            initPostInstallation(handler, args, DeployArtifact.class);
        } catch (InterruptedException ie){
            ie.printStackTrace();
            return false;
        }
        List<ModelNode> commandResults = deployArtifact();
        serverCommands.terminateSession();
        if (commandResults != null){
            return installResult(commandResults);
        } else {
            return false;
        }
    }

    private static List<ModelNode> deployArtifact() {
        return serverCommands.deployArtifact("\""+parser.getStringProperty(ARTIFACT_PATH)+"\"");
    }
}
