/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.agriculture.dag.agorha.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static Date parseDate(String str, String[] parsePatterns) throws ParseException {
        String[] stringArray = parsePatterns;
        int n = parsePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
                dateFormat.setLenient(false);
                return dateFormat.parse(str);
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw new ParseException("Cannot parse date for '" + str + "' ...", 0);
    }

    public static Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            if (pattern == null) {
                pattern = "yyyy-MM-dd";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            return dateFormat.format(date);
        }
        return null;
    }

    public static boolean beforeEquals(Date date1, Date date2) {
        return DateUtils.compare(date1, date2) <= 0;
    }

    public static boolean afterEquals(Date date1, Date date2) {
        return DateUtils.compare(date1, date2) >= 0;
    }

    public static int compare(Date date1, Date date2) {
        long msDate1 = date1.getTime() / 1000L;
        long msDate2 = date2.getTime() / 1000L;
        return DateUtils.toInt(msDate1 - msDate2);
    }

    private static int toInt(long big) {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, big));
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarField, amount);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }
}

