package org.jbpm.designer.notification;

import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.workbench.events.NotificationEvent;

@Portable
public class DesignerNotificationEvent {

    private final String notification;
    private final NotificationEvent.NotificationType type;
    private final String userId;

    public DesignerNotificationEvent() {
        this( "Designernotification", "message", "userid" );
    }

    public DesignerNotificationEvent( final String notification,
                                      final String message,
                                      final String userId) {
        this( notification,
              NotificationEvent.NotificationType.DEFAULT,
              userId);
    }

    public DesignerNotificationEvent( final String notification,
                                      final NotificationEvent.NotificationType type,
                                      final String userId) {
        this.notification = notification;
        this.type = type;
        this.userId = userId;
    }

    public String getNotification() {
        return this.notification;
    }

    public NotificationEvent.NotificationType getType() {
        return type;
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String toString() {
        return "DesignerNotificationEvent [notification=" + notification + ", type=" + type + ", userId=" + userId + "]";
    }
}
