package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import org.jboss.dmr.ModelNode;

import java.util.List;

public class DefaultVault extends Vault {
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        serverCommands = initServerCommands(DefaultVault.class);
        try {
            ServerCommandsHelper.connectContext(handler, serverCommands);
        } catch (InterruptedException ie){
            ie.printStackTrace();
            return false;
        }

        initializeDefaultVault();
        initVaultSession();
        List<ModelNode> commandResults = installVault();
        serverCommands.terminateSession();

        if (commandResults != null){
            return installResult(commandResults);
        } else {
            return false;
        }
    }

    static void initializeDefaultVault() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        vaultKeystoreUrl = vs.substitute(idata.getVariable("vault.keystoreloc.default"));
        vaultEncrDir = vs.substitute(idata.getVariable("vault.encrdir.default"));
        vaultIterCount = Integer.parseInt(idata.getVariable("vault.itercount.default"));
        vaultAlias = vs.substitute(idata.getVariable("vault.alias.default"));
        InstallationUtilities.addFileToCleanupList(vaultEncrDir + "/VAULT.dat");
        InstallationUtilities.addFileToCleanupList(vaultEncrDir);
    }
}
