package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import org.jboss.dmr.ModelNode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Datasource extends PostInstallation {
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        serverCommands = initServerCommands(Datasource.class);
        try {
            ServerCommandsHelper.connectContext(handler, serverCommands);
        } catch (InterruptedException ie){
            ie.printStackTrace();
            return false;
        }
        List<ModelNode> commandResults = installDatasource();
        serverCommands.terminateSession();

        if (commandResults != null){
            return installResult(commandResults);
        } else {
            return false;
        }
    }

    protected static List<ModelNode> installDatasource() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        // datasource variables
        String dsJdbcName = idata.getVariable("jdbc.driver.name");
        String dsName = idata.getVariable("jdbc.datasource.name");
        String dsJndiName = idata.getVariable("jdbc.datasource.jndiname");
        String dsMinPool = idata.getVariable("jdbc.datasource.minpoolsize");
        String dsMaxPool = idata.getVariable("jdbc.datasource.maxpoolsize");
        String dsConnectionUrl = idata.getVariable("jdbc.datasource.connectionurl");
        boolean dsIsXa = (idata.getVariable("jdbc.datasource.datasourcetype") != null &&
                idata.getVariable("jdbc.datasource.datasourcetype").equals("true"));

        // pack the xa props map
        Map<String,String> dsXaProps = new HashMap<String, String>();
        dsXaProps.put("ServerName", idata.getVariable("jdbc.datasource.xa.servername"));
        dsXaProps.put("DatabaseName", idata.getVariable("jdbc.datasource.xa.databasename"));
        dsXaProps.put("PortNumber", idata.getVariable("jdbc.datasource.xa.portnumber"));
        dsXaProps.put("URL", idata.getVariable("jdbc.datasource.xa.oracleurl"));
        dsXaProps.put("NetworkProtocol", idata.getVariable("jdbc.datasource.xa.sybaseprotocol"));
        dsXaProps.put("SelectMethod", idata.getVariable("jdbc.datasource.xa.microsoftcursor"));

        // reset counter for the next dynamicPanel
        int counter = 1;
        while (true) {
            String prop = idata.getVariable("jdbc.datasource.xa.extraprops-" + counter + "-name");
            if (prop == null) {
                break;
            }
            dsXaProps.put(prop, idata.getVariable("jdbc.datasource.xa.extraprops-" + counter + "-value"));
            counter++;
        }

        String dsUsername = idata.getVariable("jdbc.datasource.username");
        String dsPassword = idata.getVariable("jdbc.datasource.password");
        String dsXaRecoveryUser = idata.getVariable("jdbc.datasource.xa.recoveryuser");
        String dsXaRecoveryPass = idata.getVariable("jdbc.datasource.xa.recoverypass");
        String dsSecurityDomain = idata.getVariable("jdbc.datasource.securitydomain");
        boolean isSecurityDomain = Boolean.parseBoolean(idata.getVariable("jdbc.datasource.issecuritydomain"));

        if (dsIsXa) { // XA command!
            if (isSecurityDomain) {
                return serverCommands.installXaDatasourceSecurityDomain(dsName,
                        dsJndiName, dsJdbcName, dsMinPool, dsMaxPool,
                        dsSecurityDomain, dsXaProps, dsXaRecoveryUser,
                        dsXaRecoveryPass);
            } else {
                return serverCommands.installXaDatasourceUsernamePwd(dsName, dsJndiName, dsJdbcName, dsMinPool, dsMaxPool, dsUsername,
                        dsPassword, dsXaProps, dsXaRecoveryUser, dsXaRecoveryPass);
            }
        } else {
            if (isSecurityDomain) {
                return serverCommands.installDatasourceSecurityDomain(dsName, dsJndiName, dsJdbcName, dsConnectionUrl, dsMinPool,
                        dsMaxPool, dsSecurityDomain);
            } else {
                return serverCommands.installDatasourceUsernamePwd(dsName, dsJndiName, dsJdbcName, dsConnectionUrl, dsMinPool, dsMaxPool,
                        dsUsername, dsPassword);
            }
        }
    }
}
