package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.VariableSubstitutor;
import com.redhat.installer.asconfiguration.ascontroller.ServerCommandsHelper;
import com.redhat.installer.installation.util.InstallationUtilities;
import org.jboss.dmr.ModelNode;

import java.util.List;

/**
 * ProcessPanel task that initializes a custom vault
 */
public class CustomVault extends Vault {
    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        serverCommands = initServerCommands(CustomVault.class);
        try {
            ServerCommandsHelper.connectContext(handler, serverCommands);
        } catch (InterruptedException ie){
            ie.printStackTrace();
            return false;
        }
        initializeCustomVault();
        initVaultSession();
        List<ModelNode> commandResults = installVault();
        serverCommands.terminateSession();

        if (commandResults != null){
            return installResult(commandResults);
        } else {
            return false;
        }
    }

    private static void initializeCustomVault() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        vaultKeystoreUrl = vs.substitute(idata.getVariable("vault.keystoreloc"));
        vaultEncrDir = vs.substitute(idata.getVariable("vault.encrdir"));
        vaultIterCount = Integer.parseInt(idata.getVariable("vault.itercount"));
        vaultAlias = vs.substitute(idata.getVariable("vault.alias"));
        InstallationUtilities.addFileToCleanupList(vaultEncrDir + "/VAULT.dat");
        InstallationUtilities.addFileToCleanupList(vaultEncrDir);
    }
}
