/**
 * Copyright (C) 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.formModeler.editor.service;

import org.guvnor.common.services.shared.file.SupportsDelete;
import org.guvnor.common.services.shared.file.SupportsRename;
import org.guvnor.common.services.shared.file.SupportsUpdate;
import org.jboss.errai.bus.server.annotations.Remote;
import org.jbpm.formModeler.editor.model.FormEditorContextTO;
import org.uberfire.backend.vfs.Path;

@Remote
public interface FormModelerService extends SupportsUpdate<FormEditorContextTO>, SupportsRename, SupportsDelete {

    FormEditorContextTO loadForm(Path path);

    FormEditorContextTO reloadForm(Path path, String ctxUID);

    void changeContextPath(String ctxUID, Path path);

    void removeEditingForm(String ctxUID);

    Path createForm(Path path, String formName);
}
