package com.izforge.izpack.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import jline.ConsoleReader;
import jline.FileNameCompletor;

/**
 * @author Miles Tjandrawidjaja
 * 
 * Description:
 * Uses jline 0.9.94.redhat-3
 * When using this class do not get use input by any other means.
 * 
 */
public class Shell {
    
    public String getInput(){
        return getInput(false);
    }
    public String getInput(boolean raw){
        String line = null;
        try {
            ConsoleReader console = new ConsoleReader();
            while ((line = console.readLine()) != null) {
                console = null;
                if (raw) return line;
                return line.trim();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } 
        System.exit(0);
        if(raw) return line;
        return line.trim();
    }
    
    
    /**
     * Get a folder location from the user.
     * Supports autocomplete features.
     */
    public String getLocation(){
        String line = null;
        
        try {
            ConsoleReader console = new ConsoleReader();
            console.addCompletor(new FileNameCompletor());
            while ((line = console.readLine()) != null) {
                 console = null;
                 if(line.startsWith("~")) { line = line.replace("~", System.getProperty("user.home")); }
                 if(line.endsWith(File.separator)) {line = line.substring(0, line.length()-1); }
                 return line.trim();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
        return line.trim(); //Shouldn't get here
    }

    /**
     * Get a password from the user.
     * Currently the ConsoleReader does not support hiding the password being entered.
     * For some reason using a buffered reader will not show output (probably side effect of jline)
     */
    public String getPassword() 
    {        
        int ch;
        String line = null;
        StringBuilder out = new StringBuilder();
        System.out.flush();
        
        try
        {
            ConsoleReader console = new ConsoleReader();
            Character echoChar = console.getEchoCharacter();
            console.setEchoCharacter(new Character((char)0));
            while(true)
                switch((ch = console.readVirtualKey()))
                {
                        case -1:
                        case '\n':
                        case '\r':
                                System.out.println("");
                                console.setEchoCharacter(echoChar);
                                return out.toString();
                        default:
                                out.append((char)ch);
                }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        
        return line; //This should never happen
    }

    /**
     * Get a single character from the user
     * @return A character that the user has entered int.
     */
    public char getChar()
    {
        String line = null;
        try {
            ConsoleReader console = new ConsoleReader();
            while ((line = console.readLine()) != null) {
                return line.toLowerCase().charAt(0);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
        return line.toLowerCase().charAt(0);
    }
 
}
