package com.redhat.installer.tests.validator;

import com.redhat.installer.tests.DataValidatorTester;
import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.validator.SSLKeystoreValidator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * This class is essentially identical to PreExistingVaultValidatorTests
 * Created by thauser on 1/30/14.
 */
public class SSLKeystoreValidatorTest extends DataValidatorTester{
    @BeforeClass
    public static void init() throws Exception{
        idata.langpack = TestUtils.createMockLangpack("ssl.password.incorrect");
    }

    @Before
    public void setUp() throws Exception {
        dv = new SSLKeystoreValidator();
    }

    @Test
    public void testWrongPassword() throws Exception {
        idata.setVariable("ssl.path", TestUtils.mockKeystorePath);
        idata.setVariable("ssl.password", "incorrectpassword"); // must be > 6 chars for mock keystore generation
        TestUtils.createMockKeystore("jks");
        assertWarning();
        assertLangpackError("ssl.password.incorrect");
    }

    @Test
    public void testCorrectPassword() throws Exception {
        TestUtils.setCorrectSSLKeystoreVariables(idata);
        TestUtils.createMockKeystore("jks");
        assertOk();
    }

    @Test
    public void testFileNotExist() throws Exception {
        TestUtils.setCorrectSSLKeystoreVariables(idata);
        assertWarning();
        assertLangpackError("ssl.password.incorrect");
    }

    @Test
    public void testNotJKSKeystore() throws Exception {
        TestUtils.setCorrectSSLKeystoreVariables(idata);
        TestUtils.createMockKeystore("jceks");
        assertOk();
    }
}
