package com.redhat.installer.tests.util;

import com.redhat.installer.tests.TestUtils;
import com.redhat.installer.util.JDBCConnectionUtils;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Test;

import java.io.File;
import java.net.URI;
import java.net.URL;

import static junit.framework.TestCase.assertEquals;

/**
 * Created by thauser on 2/5/14.
 */
public class JDBCConnectionUtilsTest {
    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory(TestUtils.INSTALL_PATH_FILE);
    }

    @Test
    public void testConvertToUrlArrayValidUrls() throws Exception{
        String[] urls = new String[5];
        URL[] comparison = new URL[5];
        urls[0] = "file:///"+TestUtils.workingDir+TestUtils.INSTALL_PATH+"/testurl.jar";
        urls[1] = "https://s01.yyz.redhat.com/thauser/datasourcejars/ibm/db2/main/db2jcc4.jar";
        urls[2] = "ftp://localhost/datasourcejars/db2jcc.jar";
        urls[3] = "file:///some/file/here";
        urls[4] = "http://vanilla.com/http/protocol";

        for (int i = 0; i < comparison.length; i++){
            comparison[i] = new URI(urls[i]).toURL();
        }
        URL[] result = JDBCConnectionUtils.convertToUrlArray(urls);
        for (int i = 0; i < result.length; i++){
            assertEquals(comparison[i].toString(), result[i].toString());
        }
    }

    //TODO: define the behavior of what the JDBCConnectionUtils should do if we encounter an unspecified protocol
    @Test
    public void testConvertToUrlArrayInvalidUrls() throws Exception {
        String [] urls = new String[2];
        URL [] comparison = new URL[2];
        urls[0] = "file:///local/file/is/here";
        urls[1] = "ftps://unsupported/protocol"; // doing new URI().toURL() will result in an exception
        // TODO: rest of the test once the new behavior is defined.
    }

    @Test
    public void testGetDatabaseConnectionValid() throws Exception {

    }

    @Test
    public void testGetDatabaseConnectionInvalidDriver(){

    }

    @Test
    public void testGetDatabaseConnectionWrongUsername(){

    }

    @Test
    public void testGetDatabaseConnectionWrongPassword(){

    }

    @Test
    public void testGetDatabaseConnectionWrongUrl(){

    }

    @Test
    public void testVerifyJarPathValid() throws Exception{
        String path = "/zip-file.zip";
        TestUtils.createNewZipFile(path);
        assertEquals(0, JDBCConnectionUtils.verifyJarPath(TestUtils.baseTestDir+path));
    }

    @Test
    public void testVerifyJarPathInvalid() throws Exception {
        TestUtils.createMockInstallDir();
        assertEquals(1, JDBCConnectionUtils.verifyJarPath(TestUtils.baseTestDir));
    }

    @Test
    public void testVerifyJarPathNonZip() throws Exception {
        String path = "/non-zip-file.txt";
        TestUtils.createNewEmptyFile(path);
        assertEquals(2, JDBCConnectionUtils.verifyJarPath(TestUtils.baseTestDir + path));
    }

    @Test
    public void testVerifyJarPathEmptyZip() throws Exception{
        new File(TestUtils.baseTestDir).mkdirs();
        String path = "/empty-zip.zip";
        TestUtils.createNewEmptyZipFile(path);
        assertEquals(3, JDBCConnectionUtils.verifyJarPath(TestUtils.baseTestDir + path));
    }

    @Test
    public void testVerifyJarPathUnreachable() throws Exception {
        assertEquals(4, JDBCConnectionUtils.verifyJarPath("http://unreachablehostforsure.com/non-existent-file.jar"));
    }

    //TODO: perhaps reference remote driver jars for these tests? seems a little fragile / hard to test
    @Test
    public void testFindDriverClassValid(){

    }

    @Test
    public void testFindDriverClassInvalid(){

    }
}
